/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class LengthRestriction
implements PasswordRestriction {
    private final int desiredLength;
    private final boolean must;

    public LengthRestriction(int desiredLength, boolean must) {
        this.desiredLength = desiredLength;
        this.must = must;
    }

    @Override
    public String getRequirementMessage() {
        return DomainManagementLogger.ROOT_LOGGER.passwordLengthInfo(this.desiredLength);
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        if (password == null || password.length() < this.desiredLength) {
            throw this.must ? DomainManagementLogger.ROOT_LOGGER.passwordNotLongEnough(this.desiredLength) : DomainManagementLogger.ROOT_LOGGER.passwordShouldHaveXCharacters(this.desiredLength);
        }
    }
}

