/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authentication.schemes;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.config.http.X509AuthenticationConfiguration;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.http.authentication.HttpAuthenticationScheme;
import org.picketlink.idm.credential.X509CertificateCredentials;

public class X509AuthenticationScheme
implements HttpAuthenticationScheme<X509AuthenticationConfiguration> {
    public static final String X509_CLIENT_CERT_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private X509AuthenticationConfiguration config;

    public void initialize(X509AuthenticationConfiguration config) {
        this.config = config;
    }

    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        X509Certificate[] clientCerts = this.getClientCertificate(request);
        if (clientCerts != null && clientCerts.length > 0) {
            X509CertificateCredentials credential = new X509CertificateCredentials(clientCerts[0], this.config.getSubjectRegex());
            credential.setTrusted(true);
            creds.setCredential((Object)credential);
        }
    }

    public void challengeClient(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendError(403, "The requested resource requires a valid certificate.");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not challenge client credentials.", e);
        }
    }

    public void onPostAuthentication(HttpServletRequest request, HttpServletResponse response) {
    }

    private X509Certificate[] getClientCertificate(HttpServletRequest request) {
        return (X509Certificate[])request.getAttribute(X509_CLIENT_CERT_REQUEST_ATTRIBUTE);
    }
}

