/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.RemoteDMRAttributes;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class RemoteDMRAdd
extends MonitorServiceAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(RemoteDMRAdd.class);
    public static final RemoteDMRAdd INSTANCE = new RemoteDMRAdd();

    private RemoteDMRAdd() {
        super(RemoteDMRAttributes.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        MonitorServiceConfiguration config = Util.getMonitorServiceConfiguration(context);
        String newEndpointName = context.getCurrentAddressValue();
        MonitorServiceConfiguration.EndpointConfiguration endpointConfig = config.getDmrConfiguration().getEndpoints().get(newEndpointName);
        boolean isEnabled = endpointConfig.isEnabled();
        String newTenantId = endpointConfig.getTenantId();
        if (newTenantId != null) {
            try {
                monitorService.registerFeed(newTenantId, 0);
            }
            catch (Exception e) {
                isEnabled = false;
                log.warnCannotRegisterFeedForNewManagedServer(newTenantId, newEndpointName, e.toString());
            }
        }
        if (isEnabled) {
            ProtocolServices newServices = monitorService.createProtocolServicesBuilder().dmrProtocolService(null, config.getDmrConfiguration()).build();
            EndpointService<DMRNodeLocation, DMRSession> endpointService = newServices.getDmrProtocolService().getEndpointServices().get(newEndpointName);
            ProtocolService<DMRNodeLocation, DMRSession> dmrService = monitorService.getProtocolServices().getDmrProtocolService();
            dmrService.add(endpointService);
            monitorService.registerAllResourceTypes();
        }
    }
}

