/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.AvailsCollector;
import org.hawkular.agent.monitor.scheduler.MetricsCollector;
import org.hawkular.agent.monitor.scheduler.ScheduledCollectionsQueue;
import org.hawkular.agent.monitor.scheduler.ScheduledMeasurementInstance;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.DataPoint;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.util.Consumer;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;

public abstract class MeasurementScheduler<L, T extends MeasurementType<L>, D extends DataPoint> {
    private static final MsgLogger LOG = AgentLoggers.getLogger(MeasurementScheduler.class);
    private final String name;
    private final ExecutorService executorService;
    private final Map<SamplingService<L>, ScheduledCollectionsQueue<L, T>> queues = new HashMap<SamplingService<L>, ScheduledCollectionsQueue<L, T>>();
    private final Consumer<D> completionHandler;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public static <LL> MeasurementScheduler<LL, MetricType<LL>, MetricDataPoint> forMetrics(String name, Consumer<MetricDataPoint> completionHandler) {
        return new MeasurementScheduler<LL, MetricType<LL>, MetricDataPoint>(name, completionHandler){

            @Override
            protected Runnable createCollector(SamplingService<LL> endpointService, ScheduledCollectionsQueue<LL, MetricType<LL>> queue, Consumer<MetricDataPoint> completionHandler) {
                return new MetricsCollector(endpointService, queue, completionHandler);
            }

            @Override
            protected Collection<ScheduledMeasurementInstance<LL, MetricType<LL>>> getScheduledMeasurementInstances(Resource<LL> resource) {
                return ScheduledMeasurementInstance.createMetrics(resource);
            }
        };
    }

    public static <LL> MeasurementScheduler<LL, AvailType<LL>, AvailDataPoint> forAvails(String name, Consumer<AvailDataPoint> completionHandler) {
        return new MeasurementScheduler<LL, AvailType<LL>, AvailDataPoint>(name, completionHandler){

            @Override
            protected Runnable createCollector(SamplingService<LL> endpointService, ScheduledCollectionsQueue<LL, AvailType<LL>> queue, Consumer<AvailDataPoint> completionHandler) {
                return new AvailsCollector(endpointService, queue, completionHandler);
            }

            @Override
            protected Collection<ScheduledMeasurementInstance<LL, AvailType<LL>>> getScheduledMeasurementInstances(Resource<LL> resource) {
                return ScheduledMeasurementInstance.createAvails(resource);
            }
        };
    }

    private MeasurementScheduler(String name, Consumer<D> completionHandler) {
        this.name = name;
        this.completionHandler = completionHandler;
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, name);
        this.executorService = Executors.newCachedThreadPool(threadFactory);
    }

    public void schedule(SamplingService<L> endpointService, Collection<Resource<L>> resources) {
        this.status.assertRunning(this.getClass(), "schedule()");
        ArrayList schedules = new ArrayList();
        for (Resource<L> resource : resources) {
            schedules.addAll(this.getScheduledMeasurementInstances(resource));
        }
        ScheduledCollectionsQueue queue = this.createOrGetScheduledCollectionsQueue(endpointService);
        queue.schedule(schedules);
        LOG.debugf("Scheduler [%s]: [%d] measurements for [%d] resources have been scheduled for endpoint [%s]", new Object[]{this.name, schedules.size(), resources.size(), endpointService});
    }

    public void unschedule(SamplingService<L> endpointService, Collection<Resource<L>> resources) {
        this.status.assertRunning(this.getClass(), "unschedule()");
        ScheduledCollectionsQueue<L, T> queue = this.getScheduledCollectionsQueue(endpointService);
        if (queue != null) {
            queue.unschedule(resources);
        }
        LOG.debugf("Scheduler [%s]: all measurements for [%d] resources have been unscheduled for endpoint [%s]", this.name, resources.size(), endpointService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledCollectionsQueue<L, T> createOrGetScheduledCollectionsQueue(SamplingService<L> endpointService) {
        Map<SamplingService<L>, ScheduledCollectionsQueue<L, T>> map = this.queues;
        synchronized (map) {
            ScheduledCollectionsQueue<L, T> q = this.queues.get(endpointService);
            if (q == null) {
                q = new ScheduledCollectionsQueue();
                this.queues.put(endpointService, q);
                Runnable collector = this.createCollector(endpointService, q, this.completionHandler);
                this.executorService.submit(collector);
            }
            return q;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledCollectionsQueue<L, T> getScheduledCollectionsQueue(SamplingService<L> endpointService) {
        Map<SamplingService<L>, ScheduledCollectionsQueue<L, T>> map = this.queues;
        synchronized (map) {
            ScheduledCollectionsQueue<L, T> q = this.queues.get(endpointService);
            return q;
        }
    }

    public void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        this.status = ServiceStatus.RUNNING;
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        LOG.debugf("Stopping scheduler [%s]", this.name);
        try {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            LOG.debugf("Scheduler [%s] stopped", this.name);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.status = ServiceStatus.STOPPED;
        }
    }

    protected abstract Runnable createCollector(SamplingService<L> var1, ScheduledCollectionsQueue<L, T> var2, Consumer<D> var3);

    protected abstract Collection<ScheduledMeasurementInstance<L, T>> getScheduledMeasurementInstances(Resource<L> var1);
}

