/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import org.jboss.aesh.cl.parser.CommandLineCompletionParser;

public class ParsedCompleteObject {
    private String name;
    private String value = "";
    private Class<?> type;
    private final boolean option;
    private boolean displayOptions = false;
    private boolean argument = false;
    private final boolean displayArguments = false;
    private boolean completeOptionName = false;
    private int offset = 0;
    private CommandLineCompletionParser completionParser;

    public ParsedCompleteObject(boolean displayArguments, CommandLineCompletionParser completionParser) {
        this.option = !displayArguments;
        this.argument = !this.option;
        this.completionParser = completionParser;
    }

    public ParsedCompleteObject(boolean displayOptions, String name, int offset, CommandLineCompletionParser completionParser) {
        this.displayOptions = displayOptions;
        this.offset = offset;
        this.name = name;
        this.value = "";
        this.type = null;
        this.option = false;
        this.completionParser = completionParser;
    }

    public ParsedCompleteObject(boolean displayOptions, String name, int offset, boolean completeOptionName, CommandLineCompletionParser completionParser) {
        this(displayOptions, name, offset, completionParser);
        this.completeOptionName = completeOptionName;
    }

    public ParsedCompleteObject(String name, String value, Class<?> type, boolean option, boolean completeOptionName, CommandLineCompletionParser completionParser) {
        this(name, value, type, option, completionParser);
        this.completeOptionName = completeOptionName;
    }

    public ParsedCompleteObject(String name, String value, Class<?> type, boolean option, CommandLineCompletionParser completionParser) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.option = option;
        this.argument = !this.option;
        this.offset = value.length();
        this.completionParser = completionParser;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isOption() {
        return this.option;
    }

    public boolean isArgument() {
        return this.argument;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean doDisplayOptions() {
        return this.displayOptions;
    }

    public boolean isCompleteOptionName() {
        return this.completeOptionName;
    }

    public CommandLineCompletionParser getCompletionParser() {
        return this.completionParser;
    }

    public String toString() {
        return "ParsedCompleteObject{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", type=" + this.type + ", option=" + this.option + ", argument=" + this.argument + ", displayOptions=" + this.displayOptions + ", displayArguments=" + false + ", completeOptionName=" + this.completeOptionName + ", offset=" + this.offset + '}';
    }
}

