/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.util.Arrays;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTasks;

class PatchingTaskDescription {
    private final String patchId;
    private final ContentModification modification;
    private final PatchContentLoader loader;
    private final boolean conflicts;
    private final boolean skipIfTheSame;

    PatchingTaskDescription(String patchId, ContentModification modification, PatchContentLoader loader, boolean conflicts, boolean skipIfExists) {
        this.patchId = patchId;
        this.modification = modification;
        this.loader = loader;
        this.conflicts = conflicts;
        this.skipIfTheSame = skipIfExists;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public ContentModification getModification() {
        return this.modification;
    }

    public ModificationType getModificationType() {
        return this.modification.getType();
    }

    public ContentItem getContentItem() {
        return this.modification.getItem();
    }

    public <T extends ContentItem> T getContentItem(Class<T> expected) {
        return this.modification.getItem(expected);
    }

    public ContentType getContentType() {
        return this.modification.getItem().getContentType();
    }

    public PatchContentLoader getLoader() {
        return this.loader;
    }

    public boolean hasConflicts() {
        return this.conflicts;
    }

    public boolean skipIfTheSame() {
        return this.skipIfTheSame;
    }

    static PatchingTaskDescription create(PatchingTasks.ContentTaskDefinition definition, PatchContentLoader loader) {
        ContentModification modification = PatchingTaskDescription.resolveDefinition(definition);
        ContentItem item = definition.getTarget().getItem();
        byte[] currentHash = definition.getLatest().getTargetHash();
        byte[] newContentHash = item.getContentHash();
        boolean skipIfExists = Arrays.equals(currentHash, newContentHash);
        return new PatchingTaskDescription(definition.getTarget().getPatchId(), modification, loader, definition.hasConflicts(), skipIfExists);
    }

    static ContentModification resolveDefinition(PatchingTasks.ContentTaskDefinition definition) {
        if (definition.getLatest() == definition.getTarget()) {
            return definition.getTarget().getModification();
        }
        ContentItem backupItem = definition.getTarget().getItem();
        ContentModification modification = definition.getTarget().getModification();
        byte[] target = definition.getLatest().getTargetHash();
        return new ContentModification(backupItem, target, modification.getType(), modification.getCondition());
    }
}

