/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.core.Assertions;
import org.wildfly.plugin.core.ContainerDescription;
import org.wildfly.plugin.core.DefaultContainerDescription;
import org.wildfly.plugin.core.DeploymentOperations;
import org.wildfly.plugin.core.OperationExecutionException;

public class ServerHelper {
    private static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private static final Logger LOGGER = Logger.getLogger(ServerHelper.class);

    public static ContainerDescription getContainerDescription(ModelControllerClient client) throws IOException, OperationExecutionException {
        return DefaultContainerDescription.lookup(Assertions.requiresNotNullParameter(client, "client"));
    }

    public static boolean isDomainServer(ModelControllerClient client) throws IOException {
        boolean result = false;
        ModelNode op = Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"launch-type");
        ModelNode opResult = Assertions.requiresNotNullParameter(client, "client").execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)opResult)) {
            result = "DOMAIN".equalsIgnoreCase(Operations.readResult((ModelNode)opResult).asString());
        }
        return result;
    }

    public static void waitForDomain(ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        ServerHelper.waitForDomain(null, client, startupTimeout);
    }

    public static void waitForDomain(Process process, ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        long timeout;
        Assertions.requiresNotNullParameter(client, "client");
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isDomainRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            if (process != null && ProcessHelper.processHasDied((Process)process)) {
                throw new RuntimeException(String.format("The process has unexpectedly exited with code %d", process.exitValue()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            if (process != null) {
                process.destroy();
            }
            throw new TimeoutException(String.format("The server did not start within %s seconds.", startupTimeout));
        }
    }

    public static boolean isDomainRunning(ModelControllerClient client) {
        return ServerHelper.isDomainRunning(client, false);
    }

    public static void shutdownDomain(ModelControllerClient client) throws IOException, OperationExecutionException {
        ServerHelper.shutdownDomain(client, 0);
    }

    public static void shutdownDomain(ModelControllerClient client, int timeout) throws IOException, OperationExecutionException {
        ModelNode stopServersOp = Operations.createOperation((String)"stop-servers");
        stopServersOp.get("blocking").set(true);
        stopServersOp.get("timeout").set(timeout);
        ModelNode response = client.execute(stopServersOp);
        if (!Operations.isSuccessfulOutcome((ModelNode)response)) {
            throw new OperationExecutionException("Failed to stop servers.", stopServersOp, response);
        }
        ModelNode address = ServerHelper.determineHostAddress(client);
        ModelNode shutdownOp = Operations.createOperation((String)"shutdown", (ModelNode)address);
        response = client.execute(shutdownOp);
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            while (ServerHelper.isDomainRunning(client, true)) {
                try {
                    TimeUnit.MILLISECONDS.sleep(20L);
                }
                catch (InterruptedException e) {
                    LOGGER.debug((Object)"Interrupted during sleep", (Throwable)e);
                }
            }
        } else {
            throw new OperationExecutionException("Failed to shutdown host.", shutdownOp, response);
        }
    }

    public static ModelNode determineHostAddress(ModelControllerClient client) throws IOException, OperationExecutionException {
        ModelNode op = Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"local-host-name");
        ModelNode response = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            return DeploymentOperations.createAddress("host", Operations.readResult((ModelNode)response).asString());
        }
        throw new OperationExecutionException(op, response);
    }

    public static void waitForStandalone(ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        ServerHelper.waitForStandalone(null, client, startupTimeout);
    }

    public static void waitForStandalone(Process process, ModelControllerClient client, long startupTimeout) throws InterruptedException, RuntimeException, TimeoutException {
        long timeout;
        Assertions.requiresNotNullParameter(client, "client");
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isStandaloneRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            if (process != null && ProcessHelper.processHasDied((Process)process)) {
                throw new RuntimeException(String.format("The process has unexpectedly exited with code %d", process.exitValue()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            if (process != null) {
                process.destroy();
            }
            throw new TimeoutException(String.format("The server did not start within %s seconds.", startupTimeout));
        }
    }

    public static boolean isStandaloneRunning(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state"));
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.debug((Object)"Interrupted determining if standalone is running", (Throwable)e);
        }
        return false;
    }

    public static void shutdownStandalone(ModelControllerClient client) throws IOException {
        ServerHelper.shutdownStandalone(client, 0);
    }

    public static void shutdownStandalone(ModelControllerClient client, int timeout) throws IOException {
        ModelNode op = Operations.createOperation((String)"shutdown");
        op.get("timeout").set(timeout);
        ModelNode response = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            while (ServerHelper.isStandaloneRunning(client)) {
                try {
                    TimeUnit.MILLISECONDS.sleep(20L);
                }
                catch (InterruptedException e) {
                    LOGGER.debug((Object)"Interrupted during sleep", (Throwable)e);
                }
            }
        } else {
            throw new OperationExecutionException(op, response);
        }
    }

    private static boolean isDomainRunning(ModelControllerClient client, boolean shutdown) {
        DomainClient domainClient = client instanceof DomainClient ? (DomainClient)client : DomainClient.Factory.create((ModelControllerClient)client);
        try {
            ModelNode hostAddress = ServerHelper.determineHostAddress((ModelControllerClient)domainClient);
            Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create().addStep(Operations.createReadAttributeOperation((ModelNode)hostAddress, (String)"running-mode")).addStep(Operations.createReadAttributeOperation((ModelNode)hostAddress, (String)"host-state"));
            ModelNode response = domainClient.execute(builder.build());
            if (Operations.isSuccessfulOutcome((ModelNode)response) && "ADMIN_ONLY".equals(Operations.readResult((ModelNode)(response = Operations.readResult((ModelNode)response)).get("step-1")).asString()) && Operations.isSuccessfulOutcome((ModelNode)response.get("step-2"))) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
            HashMap<ServerIdentity, ServerStatus> servers = new HashMap<ServerIdentity, ServerStatus>();
            Map statuses = domainClient.getServerStatuses();
            for (ServerIdentity id : statuses.keySet()) {
                ServerStatus status = (ServerStatus)statuses.get(id);
                switch (status) {
                    case DISABLED: 
                    case STARTED: {
                        servers.put(id, status);
                    }
                }
            }
            if (shutdown) {
                return statuses.isEmpty();
            }
            return statuses.size() == servers.size();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Interrupted determining if domain is running", (Throwable)e);
            return false;
        }
    }

    static {
        EMPTY_ADDRESS.protect();
    }
}

