/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;

public class JournalRecord {
    private final JournalFile addFile;
    private final int size;
    private List<Pair<JournalFile, Integer>> updateFiles;

    public JournalRecord(JournalFile addFile, int size) {
        this.addFile = addFile;
        this.size = size;
        addFile.incPosCount();
        addFile.addSize(size);
    }

    void addUpdateFile(JournalFile updateFile, int size) {
        if (this.updateFiles == null) {
            this.updateFiles = new ArrayList<Pair<JournalFile, Integer>>();
        }
        this.updateFiles.add(new Pair<JournalFile, Integer>(updateFile, size));
        updateFile.incPosCount();
        updateFile.addSize(size);
    }

    void delete(JournalFile file) {
        file.incNegCount(this.addFile);
        this.addFile.decSize(this.size);
        if (this.updateFiles != null) {
            for (Pair<JournalFile, Integer> updFile : this.updateFiles) {
                file.incNegCount(updFile.getA());
                updFile.getA().decSize(updFile.getB());
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("JournalRecord(add=" + this.addFile.getFile().getFileName());
        if (this.updateFiles != null) {
            for (Pair<JournalFile, Integer> update : this.updateFiles) {
                buffer.append(", update=" + update.getA().getFile().getFileName());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

