/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PersistenceContextObjectInitializer
implements ObjectInitializer {
    private static final Log log = LoggerFactory.make();
    private final ObjectInitializer delegate;

    public PersistenceContextObjectInitializer(ObjectInitializer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap, ObjectInitializationContext objectInitializationContext) {
        int numberOfObjectsToInitialize = entityInfos.length;
        if (numberOfObjectsToInitialize == 0) {
            if (log.isTraceEnabled()) {
                log.tracef("No object to initialize", numberOfObjectsToInitialize);
            }
            return;
        }
        SessionImplementor sessionImplementor = (SessionImplementor)objectInitializationContext.getSession();
        String entityName = objectInitializationContext.getSession().getSessionFactory().getClassMetadata(objectInitializationContext.getEntityType()).getEntityName();
        EntityPersister persister = sessionImplementor.getFactory().getEntityPersister(entityName);
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        ArrayList<EntityInfo> remainingEntityInfos = new ArrayList<EntityInfo>(numberOfObjectsToInitialize);
        for (EntityInfo entityInfo : entityInfos) {
            if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, objectInitializationContext.getSession())) {
                EntityKey entityKey = sessionImplementor.generateEntityKey(entityInfo.getId(), persister);
                Object o = persistenceContext.getEntity(entityKey);
                if (o == null) {
                    remainingEntityInfos.add(entityInfo);
                    continue;
                }
                EntityInfoLoadKey key = new EntityInfoLoadKey(entityInfo.getClazz(), entityInfo.getId());
                idToObjectMap.put(key, o);
                continue;
            }
            remainingEntityInfos.add(entityInfo);
        }
        int remainingSize = remainingEntityInfos.size();
        if (log.isTraceEnabled()) {
            log.tracef("Initialized %d objects out of %d in the persistence context", numberOfObjectsToInitialize - remainingSize, numberOfObjectsToInitialize);
        }
        if (remainingSize > 0) {
            this.delegate.initializeObjects(remainingEntityInfos.toArray(new EntityInfo[remainingSize]), idToObjectMap, objectInitializationContext);
        }
    }
}

