/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Collections;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseOperationTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleSyncedFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.Path;

public final class BaseResourceTypes {
    private BaseResourceTypes() {
    }

    static class ResourceTypeDataModificationChecks<BE>
    implements BaseData.DataModificationChecks<BE> {
        private final TraversalContext<BE, ?> context;

        public ResourceTypeDataModificationChecks(TraversalContext<BE, ?> context) {
            this.context = context;
        }

        @Override
        public void preCreate(DataEntity.Blueprint blueprint, Transaction<BE> tx) {
            BE pack = tx.querySingle(this.context.select().path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (pack != null) {
                BE rt = tx.querySingle(this.context.select().get());
                throw new IllegalArgumentException("Data '" + blueprint.getId() + "' cannot be created" + " under resource type " + tx.extractCanonicalPath(rt) + ", because it is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postCreate(BE dataEntity, Transaction<BE> tx) {
        }

        @Override
        public void preUpdate(BE dataEntity, DataEntity.Update update, Transaction<BE> tx) {
            if (update.getValue() == null) {
                return;
            }
            BE mp = tx.traverseToSingle(dataEntity, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (mp != null) {
                CanonicalPath dataPath = tx.extractCanonicalPath(dataEntity);
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be updated" + " under resource type " + dataPath.up() + ", because it is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postUpdate(BE dataEntity, Transaction<BE> tx) {
        }

        @Override
        public void preDelete(BE dataEntity, Transaction<BE> tx) {
            CanonicalPath dataPath = tx.extractCanonicalPath(dataEntity);
            Object rt = null;
            try {
                rt = tx.find(dataPath.up());
            }
            catch (ElementNotFoundException e) {
                Fetcher.throwNotFoundException(this.context);
            }
            if (ReadWrite.isResourceTypeInMetadataPack(rt, tx)) {
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be deleted" + " under resource type " + dataPath.up() + ", because it is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void postDelete(BE dataEntity, Transaction<BE> tx) {
        }
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Multiple {
        public Multiple(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedTo(Relationships.WellKnown.defines, Resource.class).get());
        }

        @Override
        public MetricTypes.Read metricTypes() {
            return new BaseMetricTypes.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }

        @Override
        public OperationTypes.ReadContained operationTypes() {
            return new BaseOperationTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, OperationType.class).get());
        }

        @Override
        public Data.Read<DataRole.ResourceType> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new ResourceTypeDataModificationChecks(this.context));
        }

        @Override
        public ResourceTypes.Read identical() {
            return new Read(this.context.proceed().hop(With.sameIdentityHash()).get());
        }
    }

    public static class Single<BE>
    extends SingleSyncedFetcher<BE, ResourceType, ResourceType.Blueprint, ResourceType.Update>
    implements ResourceTypes.Single {
        public Single(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedTo(Relationships.WellKnown.defines, Resource.class).get());
        }

        @Override
        public MetricTypes.ReadAssociate metricTypes() {
            return new BaseMetricTypes.ReadAssociate(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }

        @Override
        public OperationTypes.ReadWrite operationTypes() {
            return new BaseOperationTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, OperationType.class).get());
        }

        @Override
        protected void preDelete(BE deletedEntity, Transaction<BE> tx) {
            if (ReadWrite.isResourceTypeInMetadataPack(deletedEntity, tx)) {
                throw new IllegalArgumentException("Cannot delete a resource type that is part of a metadata pack. This would invalidate the meta data pack's identity.");
            }
        }

        @Override
        protected void preUpdate(BE updatedEntity, ResourceType.Update update, Transaction<BE> transaction) {
        }

        @Override
        public Data.ReadWrite<DataRole.ResourceType> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), DataRole.ResourceType.class, new ResourceTypeDataModificationChecks(this.context));
        }

        @Override
        public ResourceTypes.Read identical() {
            return new Read(this.context.proceed().hop(With.sameIdentityHash()).get());
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Read {
        public Read(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.ReadContained {
        public ReadContained(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, ResourceType, ResourceType.Blueprint, ResourceType.Update, String>
    implements ResourceTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Transaction<BE> tx, ResourceType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<BE, ResourceType> wireUpNewEntity(BE entity, ResourceType.Blueprint blueprint, CanonicalPath parentPath, BE parent, Transaction<BE> tx) {
            tx.update(entity, ResourceType.Update.builder().build());
            ResourceType resourceType = new ResourceType(blueprint.getName(), parentPath.extend(ResourceType.SEGMENT_TYPE, tx.extractId(entity)).get(), null, null, null, blueprint.getProperties());
            return new EntityAndPendingNotifications<BE, ResourceType>(entity, resourceType, Collections.emptyList());
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public ResourceTypes.Single create(ResourceType.Blueprint blueprint, boolean cache) throws EntityAlreadyExistsException {
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint), cache));
        }

        @Override
        protected void preDelete(String s, BE entityRepresentation, Transaction<BE> tx) {
            if (ReadWrite.isResourceTypeInMetadataPack(entityRepresentation, tx)) {
                throw new IllegalArgumentException("Cannot delete a resource type that is part of a metadata pack. This would invalidate the meta data pack's identity.");
            }
        }

        @Override
        protected void preUpdate(String s, BE entityRepresentation, ResourceType.Update update, Transaction<BE> transaction) {
        }

        private static <BE> boolean isResourceTypeInMetadataPack(BE resourceType, Transaction<BE> tx) {
            return tx.traverseToSingle(resourceType, Query.path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null;
        }
    }
}

