/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompDecoder;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompSubscription;
import org.apache.activemq.artemis.core.protocol.stomp.StompUtils;
import org.apache.activemq.artemis.core.protocol.stomp.StompVersions;
import org.apache.activemq.artemis.core.protocol.stomp.v10.StompFrameHandlerV10;
import org.apache.activemq.artemis.core.protocol.stomp.v11.StompFrameHandlerV11;
import org.apache.activemq.artemis.core.protocol.stomp.v12.StompFrameHandlerV12;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;

public abstract class VersionedStompFrameHandler {
    protected StompConnection connection;
    protected StompDecoder decoder;

    public static VersionedStompFrameHandler getHandler(StompConnection connection, StompVersions version) {
        if (version == StompVersions.V1_0) {
            return new StompFrameHandlerV10(connection);
        }
        if (version == StompVersions.V1_1) {
            return new StompFrameHandlerV11(connection);
        }
        if (version == StompVersions.V1_2) {
            return new StompFrameHandlerV12(connection);
        }
        return null;
    }

    protected VersionedStompFrameHandler(StompConnection connection) {
        this.connection = connection;
    }

    public StompFrame decode(ActiveMQBuffer buffer) throws ActiveMQStompException {
        return this.decoder.decode(buffer);
    }

    public boolean hasBytes() {
        return this.decoder.hasBytes();
    }

    public StompDecoder getDecoder() {
        return this.decoder;
    }

    public StompFrame handleFrame(StompFrame request) {
        StompFrame response = null;
        response = "SEND".equals(request.getCommand()) ? this.onSend(request) : ("ACK".equals(request.getCommand()) ? this.onAck(request) : ("NACK".equals(request.getCommand()) ? this.onNack(request) : ("BEGIN".equals(request.getCommand()) ? this.onBegin(request) : ("COMMIT".equals(request.getCommand()) ? this.onCommit(request) : ("ABORT".equals(request.getCommand()) ? this.onAbort(request) : ("SUBSCRIBE".equals(request.getCommand()) ? this.onSubscribe(request) : ("UNSUBSCRIBE".equals(request.getCommand()) ? this.onUnsubscribe(request) : ("CONNECT".equals(request.getCommand()) ? this.onConnect(request) : ("STOMP".equals(request.getCommand()) ? this.onStomp(request) : ("DISCONNECT".equals(request.getCommand()) ? this.onDisconnect(request) : this.onUnknown(request.getCommand())))))))))));
        if (response == null) {
            response = this.postprocess(request);
        } else if (request.hasHeader("receipt")) {
            response.addHeader("receipt-id", request.getHeader("receipt"));
        }
        return response;
    }

    public abstract StompFrame onConnect(StompFrame var1);

    public abstract StompFrame onDisconnect(StompFrame var1);

    public abstract StompFrame onAck(StompFrame var1);

    public abstract StompFrame onUnsubscribe(StompFrame var1);

    public abstract StompFrame onStomp(StompFrame var1);

    public abstract StompFrame onNack(StompFrame var1);

    public abstract StompFrame createStompFrame(String var1);

    public StompFrame onUnknown(String command) {
        ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.unknownCommand(command).setHandler(this);
        StompFrame response = error.getFrame();
        return response;
    }

    public StompFrame handleReceipt(String receiptID) {
        StompFrame receipt = this.createStompFrame("RECEIPT");
        receipt.addHeader("receipt-id", receiptID);
        return receipt;
    }

    public StompFrame onCommit(StompFrame request) {
        StompFrame response = null;
        String txID = request.getHeader("transaction");
        if (txID == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.needTxIDHeader().setHandler(this);
            response = error.getFrame();
            return response;
        }
        try {
            this.connection.commitTransaction(txID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    public StompFrame onSend(StompFrame frame) {
        StompFrame response = null;
        try {
            this.connection.validate();
            String destination = frame.getHeader("destination");
            this.checkDestination(destination);
            String txID = frame.getHeader("transaction");
            long timestamp = System.currentTimeMillis();
            ServerMessageImpl message = this.connection.createServerMessage();
            message.setTimestamp(timestamp);
            message.setAddress(SimpleString.toSimpleString((String)destination));
            StompUtils.copyStandardHeadersFromFrameToMessage(frame, message);
            if (frame.hasHeader("content-length")) {
                message.setType((byte)4);
                message.getBodyBuffer().writeBytes(frame.getBodyAsBytes());
            } else {
                message.setType((byte)3);
                String text = frame.getBody();
                message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString((String)text));
            }
            this.connection.sendServerMessage(message, txID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        catch (Exception e) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.errorHandleSend(e).setHandler(this);
            response = error.getFrame();
        }
        return response;
    }

    private void checkDestination(String destination) throws ActiveMQStompException {
        this.connection.checkDestination(destination);
    }

    public StompFrame onBegin(StompFrame frame) {
        StompFrame response = null;
        String txID = frame.getHeader("transaction");
        if (txID == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.beginTxNoID().setHandler(this);
            response = error.getFrame();
        } else {
            try {
                this.connection.beginTransaction(txID);
            }
            catch (ActiveMQStompException e) {
                response = e.getFrame();
            }
        }
        return response;
    }

    public StompFrame onAbort(StompFrame request) {
        StompFrame response = null;
        String txID = request.getHeader("transaction");
        if (txID == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.abortTxNoID().setHandler(this);
            response = error.getFrame();
            return response;
        }
        try {
            this.connection.abortTransaction(txID);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    public StompFrame onSubscribe(StompFrame request) {
        StompFrame response = null;
        String destination = request.getHeader("destination");
        String selector = request.getHeader("selector");
        String ack = request.getHeader("ack");
        String id = request.getHeader("id");
        String durableSubscriptionName = request.getHeader("durable-subscriber-name");
        boolean noLocal = false;
        if (request.hasHeader("no-local")) {
            noLocal = Boolean.parseBoolean(request.getHeader("no-local"));
        }
        try {
            this.connection.subscribe(destination, selector, ack, id, durableSubscriptionName, noLocal);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    public StompFrame postprocess(StompFrame request) {
        StompFrame response = null;
        if (request.hasHeader("receipt")) {
            response = this.handleReceipt(request.getHeader("receipt"));
            if (request.getCommand().equals("DISCONNECT")) {
                response.setNeedsDisconnect(true);
            }
        } else if (request.getCommand().equals("DISCONNECT")) {
            this.connection.disconnect(false);
        }
        return response;
    }

    public StompFrame createMessageFrame(ServerMessage serverMessage, StompSubscription subscription, int deliveryCount) throws Exception {
        StompFrame frame = this.createStompFrame("MESSAGE");
        if (subscription.getID() != null) {
            frame.addHeader("subscription", subscription.getID());
        }
        ActiveMQBuffer buffer = serverMessage.getBodyBufferCopy();
        int bodyPos = serverMessage.getEndOfBodyPosition() == -1 ? buffer.writerIndex() : serverMessage.getEndOfBodyPosition();
        buffer.readerIndex(17);
        int size = bodyPos - buffer.readerIndex();
        byte[] data = new byte[size];
        if (serverMessage.containsProperty("content-length") || serverMessage.getType() == 4) {
            frame.addHeader("content-length", String.valueOf(data.length));
            buffer.readBytes(data);
        } else {
            SimpleString text = buffer.readNullableSimpleString();
            data = text != null ? text.toString().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        }
        frame.setByteBody(data);
        StompUtils.copyStandardHeadersFromMessageToFrame((MessageInternal)serverMessage, frame, deliveryCount);
        return frame;
    }

    public void initDecoder(VersionedStompFrameHandler existingHandler) {
        throw ActiveMQStompProtocolMessageBundle.BUNDLE.invalidCall();
    }

    public void onError(ActiveMQStompException e) {
        this.connection.sendFrame(e.getFrame());
        this.connection.destroy();
    }
}

