/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.installer;

import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class EncoderDecoder {
    private EncoderDecoder() {
    }

    public static String encode(String clearText, String key, byte[] salt) throws Exception {
        if (null == clearText) {
            return null;
        }
        if (null == key || null == salt) {
            throw new IllegalArgumentException("Key and salt must be specified.");
        }
        SecretKeySpec keySpec = EncoderDecoder.getKeySpecForKeyAndSalt(key, salt);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        try {
            cipher.init(1, keySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            keySpec = EncoderDecoder.getWeakKeySpecForKeyAndSalt(key, salt);
            cipher = Cipher.getInstance("DES");
            cipher.init(1, keySpec);
        }
        byte[] encryptedData = cipher.doFinal(clearText.getBytes("UTF-8"));
        byte[] iv = cipher.getIV();
        if (null != iv) {
            String ivAsString = new String(Base64.getEncoder().encode(cipher.getIV()), "UTF-8");
            String encryptedAsString = new String(Base64.getEncoder().encode(encryptedData), "UTF-8");
            return ivAsString + "$" + encryptedAsString;
        }
        return new String(Base64.getEncoder().encode(encryptedData), "UTF-8");
    }

    public static String decode(String encodedString, String key, byte[] salt) throws Exception {
        byte[] encodedBytes;
        Cipher cipher;
        if (null == encodedString) {
            return null;
        }
        if (null == key || null == salt) {
            throw new IllegalArgumentException("Key and salt must be specified.");
        }
        if (encodedString.contains("$")) {
            SecretKeySpec keySpec = EncoderDecoder.getKeySpecForKeyAndSalt(key, salt);
            cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            String[] parts = encodedString.split("\\$");
            byte[] iv = Base64.getDecoder().decode(parts[0]);
            encodedBytes = Base64.getDecoder().decode(parts[1]);
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
        } else {
            SecretKeySpec keySpec = EncoderDecoder.getWeakKeySpecForKeyAndSalt(key, salt);
            cipher = Cipher.getInstance("DES");
            encodedBytes = Base64.getDecoder().decode(encodedString);
            cipher.init(2, keySpec);
        }
        return new String(cipher.doFinal(encodedBytes), "UTF-8");
    }

    private static SecretKeySpec getKeySpecForKeyAndSalt(String key, byte[] salt) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), salt, 80000, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    private static SecretKeySpec getWeakKeySpecForKeyAndSalt(String key, byte[] salt) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), salt, 80000, 64);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "DES");
    }
}

