/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawkular.wildfly.module.installer.ConfigType;
import org.hawkular.wildfly.module.installer.XmlEdit;

public class DeploymentConfiguration {
    public static String DEFAULT_SERVER_CONFIG = "standalone/configuration/standalone.xml";
    private URL module;
    private File jbossHome;
    private String modulesHome;
    private String sourceServerConfig = DEFAULT_SERVER_CONFIG;
    private String targetServerConfig = DEFAULT_SERVER_CONFIG;
    private String serverConfigBackup = DEFAULT_SERVER_CONFIG + ".backup";
    private URL subsystem;
    private URL socketBinding;
    private Set<String> socketBindingGroups = new HashSet<String>();
    private List<XmlEdit> edit;
    private Set<String> profiles = new HashSet<String>();
    private ConfigType configType;
    private boolean failNoMatch;

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public URL getModule() {
        return this.module;
    }

    public File getJbossHome() {
        return this.jbossHome;
    }

    public String getModulesHome() {
        return this.modulesHome;
    }

    public String getSourceServerConfig() {
        return this.sourceServerConfig;
    }

    public String getTargetServerConfig() {
        return this.targetServerConfig;
    }

    public String getServerConfigBackup() {
        return this.serverConfigBackup;
    }

    public URL getSubsystem() {
        return this.subsystem;
    }

    public URL getSocketBinding() {
        return this.socketBinding;
    }

    public void setConfigType(ConfigType configType) {
        this.configType = configType;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = profiles;
    }

    public Set<String> getSocketBindingGroups() {
        return this.socketBindingGroups;
    }

    public List<XmlEdit> getEdit() {
        if (this.edit == null) {
            this.edit = new ArrayList<XmlEdit>();
        }
        return this.edit;
    }

    public boolean isFailNoMatch() {
        return this.failNoMatch;
    }

    public void setModule(URL module) {
        this.module = module;
    }

    public void setJbossHome(File jbossHome) {
        this.jbossHome = jbossHome;
    }

    public void setModulesHome(String modulesHome) {
        this.modulesHome = modulesHome;
    }

    public void setSourceServerConfig(String sourceServerConfig) {
        this.sourceServerConfig = sourceServerConfig;
    }

    public void setTargetServerConfig(String targetServerConfig) {
        this.targetServerConfig = targetServerConfig;
    }

    public void setServerConfigBackup(String serverConfigBackup) {
        this.serverConfigBackup = serverConfigBackup;
    }

    public void setSubsystem(URL subsystem) {
        this.subsystem = subsystem;
    }

    public void setSocketBinding(URL socketBinding) {
        this.socketBinding = socketBinding;
    }

    public void setSocketBindingGroups(Set<String> socketBindingGroups) {
        this.socketBindingGroups = socketBindingGroups;
    }

    public void setEdit(List<XmlEdit> edit) {
        this.edit = edit;
    }

    public void setFailNoMatch(boolean failNoMatch) {
        this.failNoMatch = failNoMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final DeploymentConfiguration configuration = new DeploymentConfiguration();

        public Builder module(URL module) {
            this.configuration.setModule(module);
            return this;
        }

        public Builder socketBinding(URL socketBinding) {
            this.configuration.setSocketBinding(socketBinding);
            return this;
        }

        public Builder subsystem(URL subsystemSnippet) {
            this.configuration.setSubsystem(subsystemSnippet);
            return this;
        }

        public Builder jbossHome(File jbossHome) {
            this.configuration.setJbossHome(jbossHome);
            return this;
        }

        public Builder modulesHome(String modulesHome) {
            this.configuration.setModulesHome(modulesHome);
            return this;
        }

        public Builder addXmlEdit(XmlEdit edit) {
            this.configuration.getEdit().add(edit);
            return this;
        }

        public Builder configType(ConfigType configType) {
            this.configuration.setConfigType(configType);
            return this;
        }

        public Builder addProfile(String profile) {
            this.configuration.getProfiles().add(profile);
            return this;
        }

        public Builder addSocketBindingGroup(String groupName) {
            this.configuration.getSocketBindingGroups().add(groupName);
            return this;
        }

        public Builder serverConfig(String serverConfig) {
            this.configuration.setSourceServerConfig(serverConfig);
            this.configuration.setTargetServerConfig(serverConfig);
            if (this.configuration.configType == null) {
                if (serverConfig.matches(".*standalone[^/]*.xml")) {
                    this.configType(ConfigType.STANDALONE);
                } else if (serverConfig.matches(".*host[^/]*.xml")) {
                    this.configType(ConfigType.HOST);
                } else if (serverConfig.matches(".*domain[^/]*.xml")) {
                    this.configType(ConfigType.DOMAIN);
                } else {
                    this.configType(ConfigType.STANDALONE);
                }
            }
            return this;
        }

        public DeploymentConfiguration build() {
            if (this.configuration.getConfigType() == ConfigType.DOMAIN && this.configuration.getProfiles().isEmpty()) {
                this.addProfile("default");
            }
            if (this.configuration.getSocketBindingGroups().isEmpty()) {
                this.configuration.getSocketBindingGroups().add("standard-sockets");
            }
            return this.configuration;
        }
    }
}

