/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;

public class KeyValueToken
extends AbstractToken {
    private boolean rsaKeyValue;

    public KeyValueToken(SPConstants.SPVersion version, SPConstants.IncludeTokenType includeTokenType, Policy nestedPolicy) {
        super(version, includeTokenType, null, null, null, nestedPolicy);
        this.setIncludeTokenType(includeTokenType);
        this.parseNestedPolicy(nestedPolicy, this);
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getKeyValueToken();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new KeyValueToken(this.getVersion(), this.getIncludeTokenType(), nestedPolicy);
    }

    protected void parseNestedPolicy(Policy nestedPolicy, KeyValueToken keyValueToken) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (!this.getVersion().getSPConstants().getRsaKeyValue().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getRsaKeyValue().getNamespaceURI().equals(assertionNamespace)) continue;
                if (keyValueToken.isRsaKeyValue()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                keyValueToken.setRsaKeyValue(true);
            }
        }
    }

    public boolean isRsaKeyValue() {
        return this.rsaKeyValue;
    }

    protected void setRsaKeyValue(boolean rsaKeyValue) {
        this.rsaKeyValue = rsaKeyValue;
    }
}

