/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXAJoinMessage
extends PacketImpl {
    private Xid xid;

    public SessionXAJoinMessage(Xid xid) {
        super((byte)57);
        this.xid = xid;
    }

    public SessionXAJoinMessage() {
        super((byte)57);
    }

    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.xid == null ? 0 : this.xid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAJoinMessage)) {
            return false;
        }
        SessionXAJoinMessage other = (SessionXAJoinMessage)obj;
        return !(this.xid == null ? other.xid != null : !this.xid.equals(other.xid));
    }
}

