/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.util;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.ws.WebSocketCall;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.util.Util;

public class BaseHttpClientGenerator {
    private static final MsgLogger log = AgentLoggers.getLogger(BaseHttpClientGenerator.class);
    private final Configuration configuration;
    private final OkHttpClient httpClient;

    public BaseHttpClientGenerator(Configuration configuration) {
        this.configuration = configuration;
        OkHttpClient httpClient = new OkHttpClient();
        configuration.getConnectTimeoutSeconds().ifPresent(timeout -> httpClient.setConnectTimeout((long)timeout.intValue(), TimeUnit.SECONDS));
        configuration.getReadTimeoutSeconds().ifPresent(timeout -> httpClient.setReadTimeout((long)timeout.intValue(), TimeUnit.SECONDS));
        if (this.configuration.isUseSSL()) {
            SSLContext theSslContextToUse = this.configuration.getSslContext() == null ? (this.configuration.getKeystorePath() != null ? this.buildSSLContext(this.configuration.getKeystorePath(), this.configuration.getKeystorePassword()) : null) : this.configuration.getSslContext();
            if (theSslContextToUse != null) {
                httpClient.setSslSocketFactory(theSslContextToUse.getSocketFactory());
            }
        }
        this.httpClient = httpClient;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public WebSocketCall createWebSocketCall(String url, Map<String, String> headers) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        Request request = requestBuilder.build();
        WebSocketCall wsc = WebSocketCall.create((OkHttpClient)this.getHttpClient(), (Request)request);
        return wsc;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String buildBase64Credentials() {
        return Util.base64Encode(this.configuration.getUsername() + ":" + this.configuration.getPassword());
    }

    private SSLContext buildSSLContext(String keystorePath, String keystorePassword) {
        try {
            KeyStore keyStore = this.readKeyStore(keystorePath, keystorePassword);
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot create SSL context from keystore [%s]", keystorePath), e);
        }
    }

    private KeyStore readKeyStore(String keystorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = keystorePassword.toCharArray();
        File file = new File(keystorePath);
        log.infoUseKeystore(file.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(file);){
            ks.load(fis, password);
        }
        return ks;
    }

    public static class Configuration {
        private final String username;
        private final String password;
        private final boolean useSSL;
        private final String keystorePath;
        private final String keystorePassword;
        private final SSLContext sslContext;
        private final Optional<Integer> connectTimeoutSeconds;
        private final Optional<Integer> readTimeoutSeconds;

        private Configuration(String username, String password, boolean useSSL, String keystorePath, String keystorePassword, SSLContext sslContext, Optional<Integer> connectTimeoutSeconds, Optional<Integer> readTimeoutSeconds) {
            this.username = username;
            this.password = password;
            this.useSSL = useSSL;
            this.keystorePath = keystorePath;
            this.keystorePassword = keystorePassword;
            this.sslContext = sslContext;
            this.connectTimeoutSeconds = connectTimeoutSeconds;
            this.readTimeoutSeconds = readTimeoutSeconds;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public Optional<Integer> getConnectTimeoutSeconds() {
            return this.connectTimeoutSeconds;
        }

        public Optional<Integer> getReadTimeoutSeconds() {
            return this.readTimeoutSeconds;
        }

        public static class Builder {
            private String username;
            private String password;
            private boolean useSSL;
            private String keystorePath;
            private String keystorePassword;
            private SSLContext sslContext;
            private Optional<Integer> connectTimeoutSeconds = Optional.empty();
            private Optional<Integer> readTimeoutSeconds = Optional.empty();

            public Configuration build() {
                return new Configuration(this.username, this.password, this.useSSL, this.keystorePath, this.keystorePassword, this.sslContext, this.connectTimeoutSeconds, this.readTimeoutSeconds);
            }

            public Builder username(String s) {
                this.username = s;
                return this;
            }

            public Builder password(String s) {
                this.password = s;
                return this;
            }

            public Builder useSsl(boolean b) {
                this.useSSL = b;
                return this;
            }

            public Builder keystorePath(String s) {
                this.keystorePath = s;
                return this;
            }

            public Builder keystorePassword(String s) {
                this.keystorePassword = s;
                return this;
            }

            public Builder sslContext(SSLContext s) {
                this.sslContext = s;
                return this;
            }

            public Builder connectTimeout(int connectTimeoutSeconds) {
                this.connectTimeoutSeconds = Optional.of(connectTimeoutSeconds);
                return this;
            }

            public Builder readTimeout(int readTimeoutSeconds) {
                this.readTimeoutSeconds = Optional.of(readTimeoutSeconds);
                return this;
            }
        }
    }
}

