/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;

public class OffsetDateTimeType
extends AbstractSingleColumnStandardBasicType<OffsetDateTime>
implements VersionType<OffsetDateTime>,
LiteralType<OffsetDateTime> {
    public static final OffsetDateTimeType INSTANCE = new OffsetDateTimeType();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S xxxxx", Locale.ENGLISH);

    public OffsetDateTimeType() {
        super((SqlTypeDescriptor)TimestampTypeDescriptor.INSTANCE, (JavaTypeDescriptor)OffsetDateTimeJavaDescriptor.INSTANCE);
    }

    public String objectToSQLString(OffsetDateTime value, Dialect dialect) throws Exception {
        return "{ts '" + FORMATTER.format(value) + "'}";
    }

    public OffsetDateTime seed(SessionImplementor session) {
        return OffsetDateTime.now();
    }

    public OffsetDateTime next(OffsetDateTime current, SessionImplementor session) {
        return OffsetDateTime.now();
    }

    public Comparator<OffsetDateTime> getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public String getName() {
        return OffsetDateTime.class.getSimpleName();
    }

    protected boolean registerUnderJavaType() {
        return true;
    }
}

