/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import rx.internal.schedulers.NewThreadWorker;
import rx.internal.util.RxThreadFactory;

final class GenericScheduledExecutorService {
    private static final String THREAD_NAME_PREFIX = "RxScheduledExecutorPool-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("RxScheduledExecutorPool-");
    private static final GenericScheduledExecutorService INSTANCE = new GenericScheduledExecutorService();
    private final ScheduledExecutorService executor;

    private GenericScheduledExecutorService() {
        ScheduledExecutorService exec;
        int count = Runtime.getRuntime().availableProcessors();
        if (count > 4) {
            count /= 2;
        }
        if (count > 8) {
            count = 8;
        }
        if (!NewThreadWorker.tryEnableCancelPolicy(exec = Executors.newScheduledThreadPool(count, THREAD_FACTORY)) && exec instanceof ScheduledThreadPoolExecutor) {
            NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)exec);
        }
        this.executor = exec;
    }

    public static ScheduledExecutorService getInstance() {
        return GenericScheduledExecutorService.INSTANCE.executor;
    }
}

