/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hawkular.inventory.api.filters.Filter;

public final class RecurseFilter
extends Filter {
    private final Filter[][] loopChains;

    public RecurseFilter(Filter[][] loopChains) {
        this.loopChains = loopChains;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Filter[][] getLoopChains() {
        return this.loopChains;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RecurseFilter[loopChains=[");
        Stream.of(this.loopChains).forEach(fs -> sb.append(Arrays.asList(fs)));
        sb.append("]]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecurseFilter)) {
            return false;
        }
        RecurseFilter that = (RecurseFilter)o;
        return Arrays.deepEquals((Object[])this.loopChains, (Object[])that.loopChains);
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.loopChains);
    }

    public static final class Builder {
        private final List<Filter[]> chains = new ArrayList<Filter[]>();

        public ChainBuilder startChain() {
            return new ChainBuilder();
        }

        public Builder addChain(Filter ... filterChain) {
            this.chains.add(filterChain);
            return this;
        }

        public RecurseFilter build() {
            Filter[][] chains = (Filter[][])this.chains.toArray((T[])new Filter[this.chains.size()][]);
            return new RecurseFilter(chains);
        }

        public final class ChainBuilder {
            private final List<Filter> chain = new ArrayList<Filter>();

            public ChainBuilder add(Filter ... filters) {
                Collections.addAll(this.chain, filters);
                return this;
            }

            public Builder done() {
                Builder.this.chains.add(this.chain.toArray(new Filter[this.chain.size()]));
                return Builder.this;
            }
        }
    }
}

