/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func2;

public final class OperatorToObservableSortedList<T>
implements Observable.Operator<List<T>, T> {
    private final Func2<? super T, ? super T, Integer> sortFunction;
    private static Func2 defaultSortFunction = new DefaultComparableFunction();

    public OperatorToObservableSortedList() {
        this.sortFunction = defaultSortFunction;
    }

    public OperatorToObservableSortedList(Func2<? super T, ? super T, Integer> sortFunction) {
        this.sortFunction = sortFunction;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> o) {
        return new Subscriber<T>(o){
            final List<T> list;
            {
                super(x0);
                this.list = new ArrayList();
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                try {
                    Collections.sort(this.list, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            return (Integer)OperatorToObservableSortedList.this.sortFunction.call(o1, o2);
                        }
                    });
                    o.onNext(Collections.unmodifiableList(this.list));
                    o.onCompleted();
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable e) {
                o.onError(e);
            }

            @Override
            public void onNext(T value) {
                this.list.add(value);
            }
        };
    }

    private static class DefaultComparableFunction
    implements Func2<Object, Object, Integer> {
        private DefaultComparableFunction() {
        }

        @Override
        public Integer call(Object t1, Object t2) {
            Comparable c1 = (Comparable)t1;
            Comparable c2 = (Comparable)t2;
            return c1.compareTo(c2);
        }
    }
}

