/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class BatchRunHandler
extends BaseOperationCommand {
    private final ArgumentWithValue file;
    private final ArgumentWithoutValue verbose;

    public BatchRunHandler(CommandContext ctx) {
        super(ctx, "batch-run", true);
        FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        this.file = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--file");
        this.verbose = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--verbose", "-v");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode response;
        boolean v = this.verbose.isPresent(ctx.getParsedCommandLine());
        boolean failed = false;
        try {
            ModelNode request = this.buildRequest(ctx);
            if (ctx.getConfig().isValidateOperationRequests() && request.get("operation").asString().equals("composite") && request.hasDefined("steps")) {
                List<ModelNode> steps = request.get("steps").asList();
                for (ModelNode step : steps) {
                    ModelNode opDescOutcome = Util.validateRequest(ctx, step);
                    if (opDescOutcome == null) continue;
                    Util.replaceFilePathsWithBytes(request, opDescOutcome);
                }
            }
            ModelControllerClient client = ctx.getModelControllerClient();
            try {
                response = client.execute(request);
            }
            catch (Exception e) {
                throw new CommandFormatException("Failed to perform operation: " + e.getLocalizedMessage());
            }
            if (!Util.isSuccess(response)) {
                throw new CommandFormatException(Util.getFailureDescription(response));
            }
        }
        catch (CommandLineException e) {
            failed = true;
            throw new CommandLineException("The batch failed with the following error (you are remaining in the batch editing mode to have a chance to correct the error)", e);
        }
        finally {
            if (!failed && ctx.getBatchManager().isBatchActive()) {
                ctx.getBatchManager().discardActiveBatch();
            }
        }
        if (v) {
            ctx.printLine(response.toString());
        } else {
            ctx.printLine("The batch executed successfully");
            super.handleResponse(ctx, response, true);
        }
    }

    @Override
    protected ModelNode buildRequestWOValidation(CommandContext ctx) throws CommandFormatException {
        String path = this.file.getValue(ctx.getParsedCommandLine());
        ModelNode headersNode = this.headers.isPresent(ctx.getParsedCommandLine()) ? this.headers.toModelNode(ctx) : null;
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            if (path != null) {
                throw new CommandFormatException("--file is not allowed in the batch mode.");
            }
            Batch batch = batchManager.getActiveBatch();
            List<BatchedCommand> currentBatch = batch.getCommands();
            if (currentBatch.isEmpty()) {
                batchManager.discardActiveBatch();
                throw new CommandFormatException("The batch is empty.");
            }
            ModelNode request = batch.toRequest();
            if (headersNode != null) {
                request.get("operation-headers").set(headersNode);
            }
            return request;
        }
        if (path != null) {
            File f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("File " + f.getAbsolutePath() + " does not exist.");
            }
            File currentDir = ctx.getCurrentDir();
            File baseDir = f.getParentFile();
            if (baseDir != null) {
                ctx.setCurrentDir(baseDir);
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(f));
                String line = reader.readLine();
                batchManager.activateNewBatch();
                while (line != null) {
                    ctx.handle(line);
                    line = reader.readLine();
                }
                ModelNode request = batchManager.getActiveBatch().toRequest();
                if (headersNode != null) {
                    request.get("operation-headers").set(headersNode);
                }
                ModelNode modelNode = request;
                return modelNode;
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to read file " + f.getAbsolutePath(), e);
            }
            catch (CommandLineException e) {
                throw new CommandFormatException("Failed to create batch from " + f.getAbsolutePath(), e);
            }
            finally {
                batchManager.discardActiveBatch();
                if (baseDir != null) {
                    ctx.setCurrentDir(currentDir);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new CommandFormatException("Without arguments the command can be executed only in the batch mode.");
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandLineException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        throw new UnsupportedOperationException();
    }
}

