/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.hawkular.inventory.api.model.StructuredData;

public final class StructuredDataDeserializer
extends JsonDeserializer<StructuredData> {
    public StructuredData deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.deserialize(jp);
    }

    private StructuredData deserialize(JsonParser jp) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token == null) {
            return StructuredData.get().undefined();
        }
        switch (token) {
            case START_ARRAY: {
                StructuredData.ListBuilder lst = StructuredData.get().list();
                this.deserializeList((StructuredData.AbstractListBuilder<?>)lst, jp);
                return lst.build();
            }
            case START_OBJECT: {
                StructuredData.MapBuilder map = StructuredData.get().map();
                this.deserializeMap((StructuredData.AbstractMapBuilder<?>)map, jp);
                return map.build();
            }
            case VALUE_TRUE: {
                return StructuredData.get().bool(Boolean.valueOf(true));
            }
            case VALUE_FALSE: {
                return StructuredData.get().bool(Boolean.valueOf(false));
            }
            case VALUE_NULL: {
                return StructuredData.get().undefined();
            }
            case VALUE_NUMBER_FLOAT: {
                return StructuredData.get().floatingPoint(Double.valueOf(jp.getDoubleValue()));
            }
            case VALUE_NUMBER_INT: {
                return StructuredData.get().integral(Long.valueOf(jp.getLongValue()));
            }
            case VALUE_STRING: {
                return StructuredData.get().string(jp.getText());
            }
        }
        return StructuredData.get().undefined();
    }

    private void deserializeList(StructuredData.AbstractListBuilder<?> bld, JsonParser jp) throws IOException {
        JsonToken token;
        block10: while ((token = jp.nextToken()) != null) {
            switch (token) {
                case START_ARRAY: {
                    StructuredData.InnerListBuilder lst = bld.addList();
                    this.deserializeList((StructuredData.AbstractListBuilder<?>)lst, jp);
                    lst.closeList();
                    continue block10;
                }
                case START_OBJECT: {
                    StructuredData.InnerMapBuilder map = bld.addMap();
                    this.deserializeMap((StructuredData.AbstractMapBuilder<?>)map, jp);
                    map.closeMap();
                    continue block10;
                }
                case VALUE_TRUE: {
                    bld.addBool(true);
                    continue block10;
                }
                case VALUE_FALSE: {
                    bld.addBool(false);
                    continue block10;
                }
                case VALUE_NULL: {
                    bld.addUndefined();
                    continue block10;
                }
                case VALUE_NUMBER_FLOAT: {
                    bld.addFloatingPoint(jp.getDoubleValue());
                    continue block10;
                }
                case VALUE_NUMBER_INT: {
                    bld.addIntegral(jp.getLongValue());
                    continue block10;
                }
                case VALUE_STRING: {
                    bld.addString(jp.getText());
                    continue block10;
                }
            }
            return;
        }
    }

    private void deserializeMap(StructuredData.AbstractMapBuilder<?> bld, JsonParser jp) throws IOException {
        JsonToken token;
        block10: while ((token = jp.nextValue()) != null) {
            String key = jp.getCurrentName();
            switch (token) {
                case START_ARRAY: {
                    StructuredData.InnerListBuilder lst = bld.putList(key);
                    this.deserializeList((StructuredData.AbstractListBuilder<?>)lst, jp);
                    lst.closeList();
                    continue block10;
                }
                case START_OBJECT: {
                    StructuredData.InnerMapBuilder map = bld.putMap(key);
                    this.deserializeMap((StructuredData.AbstractMapBuilder<?>)map, jp);
                    map.closeMap();
                    continue block10;
                }
                case VALUE_TRUE: {
                    bld.putBool(key, true);
                    continue block10;
                }
                case VALUE_FALSE: {
                    bld.putBool(key, false);
                    continue block10;
                }
                case VALUE_NULL: {
                    bld.putUndefined(key);
                    continue block10;
                }
                case VALUE_NUMBER_FLOAT: {
                    bld.putFloatingPoint(key, jp.getDoubleValue());
                    continue block10;
                }
                case VALUE_NUMBER_INT: {
                    bld.putIntegral(key, jp.getLongValue());
                    continue block10;
                }
                case VALUE_STRING: {
                    bld.putString(key, jp.getText());
                    continue block10;
                }
            }
            return;
        }
    }
}

