/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MeasurementUnitValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    public static final MeasurementUnitValidator ANY_REQUIRED = new MeasurementUnitValidator(false, true);
    public static final MeasurementUnitValidator ANY_OPTIONAL = new MeasurementUnitValidator(true, true);
    private final EnumSet<MeasurementUnit> allowedValues;

    public MeasurementUnitValidator(boolean nullable, MeasurementUnit ... allowed) {
        this(nullable, true, allowed);
    }

    public MeasurementUnitValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = EnumSet.allOf(MeasurementUnit.class);
    }

    public MeasurementUnitValidator(boolean nullable, boolean allowExpressions, MeasurementUnit ... allowed) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = EnumSet.noneOf(MeasurementUnit.class);
        for (MeasurementUnit tu : allowed) {
            this.allowedValues.add(tu);
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        String muString;
        MeasurementUnit mu;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && ((mu = MeasurementUnit.valueOf((String)(muString = value.asString()).toUpperCase(Locale.ENGLISH))) == null || !this.allowedValues.contains(mu))) {
            throw new OperationFailedException("Bad value [" + muString + "] for param [" + parameterName + "]");
        }
    }

    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (MeasurementUnit mu : this.allowedValues) {
            result.add(new ModelNode().set(mu.name()));
        }
        return result;
    }
}

