/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hawkular.agent.monitor.api.MetricTagPayloadBuilder;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.metrics.client.common.MetricType;

public class MetricTagPayloadBuilderImpl
implements MetricTagPayloadBuilder {
    private Map<String, Map<String, String>> allGauges = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> allCounters = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> allAvails = new HashMap<String, Map<String, String>>();
    private int count = 0;
    private String tenantId = null;

    @Override
    public void addTag(String key, String name, String value, MetricType metricType) {
        Map<String, Map<String, String>> map;
        switch (metricType) {
            case GAUGE: {
                map = this.allGauges;
                break;
            }
            case COUNTER: {
                map = this.allCounters;
                break;
            }
            case AVAILABILITY: {
                map = this.allAvails;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric type: " + metricType);
            }
        }
        Map<String, String> allTagsForMetric = map.get(key);
        if (allTagsForMetric == null) {
            allTagsForMetric = new TreeMap<String, String>();
            map.put(key, allTagsForMetric);
        }
        allTagsForMetric.put(name, value);
        ++this.count;
    }

    @Override
    public Map<String, String> toPayload() {
        HashMap<String, Map<String, String>> withMapObject = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> gaugeEntry : this.allGauges.entrySet()) {
            withMapObject.put("gauges/" + Util.urlEncode(gaugeEntry.getKey()), gaugeEntry.getValue());
        }
        for (Map.Entry<String, Map<String, String>> counterEntry : this.allCounters.entrySet()) {
            withMapObject.put("counters/" + Util.urlEncode(counterEntry.getKey()), counterEntry.getValue());
        }
        for (Map.Entry<String, Map<String, String>> availEntry : this.allAvails.entrySet()) {
            withMapObject.put("availability/" + Util.urlEncode(availEntry.getKey()), availEntry.getValue());
        }
        HashMap<String, String> withJson = new HashMap<String, String>(withMapObject.size());
        for (Map.Entry entry : withMapObject.entrySet()) {
            withJson.put((String)entry.getKey(), Util.toJson(entry.getValue()));
        }
        return withJson;
    }

    @Override
    public int getNumberTags() {
        return this.count;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }
}

