/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.hawkular.agent.prometheus.PrometheusDataFormat;
import org.hawkular.agent.prometheus.PrometheusMetricsProcessor;
import org.hawkular.agent.prometheus.binary.BinaryPrometheusMetricsProcessor;
import org.hawkular.agent.prometheus.text.TextPrometheusMetricsProcessor;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.walkers.CollectorPrometheusMetricsWalker;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;
import org.jboss.logging.Logger;

public class PrometheusScraper {
    private static final Logger log = Logger.getLogger(PrometheusScraper.class);
    private final URL url;
    private final PrometheusDataFormat knownDataFormat;

    public PrometheusScraper(String host, int port, String context) throws MalformedURLException {
        if (host == null) {
            host = "127.0.0.1";
        }
        if (port == 0) {
            port = 9090;
        }
        if (context == null || context.isEmpty()) {
            context = "/metrics";
        }
        this.url = new URL("http", host, port, context);
        this.knownDataFormat = null;
        log.debugf("Will scrape Permetheus data from URL [%s]", (Object)this.url);
    }

    public PrometheusScraper(URL url) {
        this(url, null);
    }

    public PrometheusScraper(URL url, PrometheusDataFormat dataFormat) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        this.url = url;
        this.knownDataFormat = dataFormat;
        log.debugf("Will scrape Permetheus data from URL [%s] with data format [%s]", (Object)this.url, this.knownDataFormat == null ? "<TBD>" : this.knownDataFormat);
    }

    public PrometheusScraper(File file, PrometheusDataFormat dataFormat) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (dataFormat == null) {
            throw new IllegalArgumentException("Must provide the content type for the file");
        }
        try {
            this.url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File does not have valid URL: " + file);
        }
        this.knownDataFormat = dataFormat;
        log.debugf("Will scrape Permetheus data from file [%s] with data format [%s]", (Object)this.url, (Object)this.knownDataFormat);
    }

    public List<MetricFamily> scrape() throws IOException {
        CollectorPrometheusMetricsWalker collector = new CollectorPrometheusMetricsWalker();
        this.scrape(collector);
        return collector.getAllMetricFamilies();
    }

    public void scrape(PrometheusMetricsWalker walker) throws IOException {
        OpenConnectionDetails connectionDetails = this.openConnection(this.url);
        if (connectionDetails == null || connectionDetails.inputStream == null) {
            throw new IOException("Failed to open the connection to the Prometheus endpoint");
        }
        try (InputStream inputStream = connectionDetails.inputStream;){
            PrometheusMetricsProcessor processor;
            String contentType = connectionDetails.contentType;
            if (contentType == null || contentType.contains("unknown")) {
                contentType = this.knownDataFormat.getContentType();
            }
            if (contentType.contains("application/vnd.google.protobuf")) {
                processor = new BinaryPrometheusMetricsProcessor(inputStream, walker);
            } else if (contentType.contains("text/plain")) {
                processor = new TextPrometheusMetricsProcessor(inputStream, walker);
            } else {
                log.debugf("Unknown content type for URL [%s]. Trying text format.", (Object)this.url);
                processor = new TextPrometheusMetricsProcessor(inputStream, walker);
            }
            processor.walk();
        }
    }

    protected String getBinaryFormatContentType() {
        return "application/vnd.google.protobuf; proto=io.prometheus.client.MetricFamily; encoding=delimited";
    }

    protected String getTextFormatContentType() {
        return "text/plain; version 0.0.4";
    }

    protected OpenConnectionDetails openConnection(URL endpointUrl) throws IOException {
        URLConnection conn = endpointUrl.openConnection();
        conn.setRequestProperty("Accept", this.getBinaryFormatContentType());
        InputStream stream = conn.getInputStream();
        String contentType = conn.getContentType();
        return new OpenConnectionDetails(stream, contentType);
    }

    protected class OpenConnectionDetails {
        public final InputStream inputStream;
        public final String contentType;

        public OpenConnectionDetails(InputStream is, String contentType) {
            this.inputStream = is;
            this.contentType = contentType;
        }
    }
}

