/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.walkers;

import java.util.Map;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;
import org.jboss.logging.Logger;

public class LoggingPrometheusMetricsWalker
implements PrometheusMetricsWalker {
    private static final Logger log = Logger.getLogger(LoggingPrometheusMetricsWalker.class);
    private Logger.Level logLevel;

    public LoggingPrometheusMetricsWalker() {
        this(null);
    }

    public LoggingPrometheusMetricsWalker(Logger.Level logLevel) {
        this.logLevel = logLevel != null ? logLevel : Logger.Level.DEBUG;
    }

    @Override
    public void walkStart() {
    }

    @Override
    public void walkFinish(int familiesProcessed, int metricsProcessed) {
    }

    @Override
    public void walkMetricFamily(MetricFamily family, int index) {
        log.logf(this.getLogLevel(), "Metric Family [%s] of type [%s] has [%d] metrics: %s", new Object[]{family.getName(), family.getType(), family.getMetrics().size(), family.getHelp()});
    }

    @Override
    public void walkCounterMetric(MetricFamily family, Counter metric, int index) {
        log.logf(this.getLogLevel(), "COUNTER: %s%s=%f", (Object)metric.getName(), (Object)this.buildLabelListString(metric.getLabels()), (Object)metric.getValue());
    }

    @Override
    public void walkGaugeMetric(MetricFamily family, Gauge metric, int index) {
        log.logf(this.getLogLevel(), "GAUGE: %s%s=%f", (Object)metric.getName(), (Object)this.buildLabelListString(metric.getLabels()), (Object)metric.getValue());
    }

    @Override
    public void walkSummaryMetric(MetricFamily family, Summary metric, int index) {
        log.logf(this.getLogLevel(), "SUMMARY: %s%s: count=%d, sum=%f, quantiles=%s", new Object[]{metric.getName(), this.buildLabelListString(metric.getLabels()), metric.getSampleCount(), metric.getSampleSum(), metric.getQuantiles()});
    }

    @Override
    public void walkHistogramMetric(MetricFamily family, Histogram metric, int index) {
        log.logf(this.getLogLevel(), "HISTOGRAM: %s%s: count=%d, sum=%f, buckets=%s", new Object[]{metric.getName(), this.buildLabelListString(metric.getLabels()), metric.getSampleCount(), metric.getSampleSum(), metric.getBuckets()});
    }

    protected Logger.Level getLogLevel() {
        return this.logLevel;
    }

    protected String buildLabelListString(Map<String, String> labels) {
        return this.buildLabelListString(labels, "{", "}");
    }
}

