/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jacorb.IORSettingsDefinition;
import org.jboss.as.jacorb.JacORBExtension;
import org.jboss.as.jacorb.JacORBSubsystemAdd;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.MigrateOperation;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;

public class JacORBSubsystemResource
extends SimpleResourceDefinition {
    public static final JacORBSubsystemResource INSTANCE = new JacORBSubsystemResource();

    private JacORBSubsystemResource() {
        super(PathElement.pathElement((String)"subsystem", (String)"jacorb"), JacORBExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)JacORBSubsystemAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, null, null, new DeprecationData(JacORBExtension.DEPRECATED_SINCE));
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        JacorbReloadRequiredWriteAttributeHandler attributeHander = new JacorbReloadRequiredWriteAttributeHandler(JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES);
        for (AttributeDefinition attr : JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)attributeHander);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)IORSettingsDefinition.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        MigrateOperation.registerOperation(resourceRegistration, this.getResourceDescriptionResolver());
    }

    private static class JacorbReloadRequiredWriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        public JacorbReloadRequiredWriteAttributeHandler(List<AttributeDefinition> definitions) {
            super(definitions);
        }

        protected void validateUpdatedModel(OperationContext context, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            if (!context.getProcessType().equals((Object)ProcessType.HOST_CONTROLLER)) {
                LinkedList<String> propertiesToReject = new LinkedList<String>();
                for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ON_OFF_ATTRIBUTES_TO_REJECT) {
                    if (!model.hasDefined(attributeDefinition.getName()) || !model.get(attributeDefinition.getName()).equals(JacORBSubsystemDefinitions.DEFAULT_ENABLED_PROPERTY)) continue;
                    propertiesToReject.add(attributeDefinition.getName());
                }
                for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ATTRIBUTES_TO_REJECT) {
                    if (!model.hasDefined(attributeDefinition.getName())) continue;
                    propertiesToReject.add(attributeDefinition.getName());
                }
                if (!propertiesToReject.isEmpty()) {
                    throw JacORBLogger.ROOT_LOGGER.cannotEmulateProperties(propertiesToReject);
                }
            }
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            if (attributeName.equals("security") && newValue.asString().equals("on")) {
                newValue.set("identity");
            }
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
        }
    }
}

