/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.paths.SegmentType;

public final class EntityNotFoundException
extends InventoryException {
    private final String entitySimpleTypeName;
    private final Filter[][] filters;
    private final String msg;

    public EntityNotFoundException(Class<?> entityClass, Filter[][] filters) {
        this(entityClass == null ? null : entityClass.getSimpleName(), filters);
    }

    public EntityNotFoundException(SegmentType entityType, Filter[][] filters) {
        this(entityType == null ? null : entityType.getSimpleName(), filters);
    }

    public EntityNotFoundException(String entitySimpleTypeName, Filter[][] filters) {
        this.entitySimpleTypeName = entitySimpleTypeName;
        this.filters = filters;
        this.msg = null;
    }

    public EntityNotFoundException(Filter[][] filters) {
        this((String)null, filters);
    }

    public EntityNotFoundException(String msg) {
        this.msg = msg;
        this.entitySimpleTypeName = null;
        this.filters = null;
    }

    public String getEntitySimpleTypeName() {
        return this.entitySimpleTypeName;
    }

    public Filter[][] getFilters() {
        return this.filters;
    }

    @Override
    public String getMessage() {
        if (null != this.msg) {
            return this.msg;
        }
        return (this.entitySimpleTypeName == null ? "Nothing" : "No " + this.entitySimpleTypeName) + " found on any of the following paths: " + Arrays.deepToString((Object[])this.filters);
    }
}

