/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.ContentHashable;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.IdentityHashable;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Syncable;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

final class ComputeHash {
    static final Comparator<Entity<?, ?>> ENTITY_COMPARATOR = (a, b) -> {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (!a.getClass().equals(b.getClass())) {
            return a.getClass().getName().compareTo(b.getClass().getName());
        }
        return a.getId().compareTo(b.getId());
    };
    static final Comparator<Entity.Blueprint> BLUEPRINT_COMPARATOR = (a, b) -> {
        Class bc;
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        Class ac = Blueprint.getEntityTypeOf(a);
        if (!ac.equals(bc = Blueprint.getEntityTypeOf(b))) {
            return ac.getName().compareTo(bc.getName());
        }
        return a.getId().compareTo(b.getId());
    };

    private ComputeHash() {
    }

    static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not instantiate SHA-1 digest algorithm.", e);
        }
    }

    private static <R extends DataRole> DataEntity.Blueprint<R> dummyDataBlueprint(R role) {
        return DataEntity.Blueprint.builder().withRole(role).withValue(StructuredData.get().undefined()).build();
    }

    static Hashes of(InventoryStructure<?> inventory, CanonicalPath rootPath, boolean computeIdentity, boolean computeContent, boolean computeSync) {
        HashConstructor ctor = new HashConstructor(new DigestComputingWriter(ComputeHash.newDigest()));
        IntermediateHashResult res = ComputeHash.computeHash(rootPath, inventory.getRoot(), HashableView.of(inventory), ctor, computeIdentity, computeContent, computeSync, rp -> null);
        return new Hashes(res.identityHash, res.contentHash, res.syncHash);
    }

    static IntermediateHashResult treeOf(InventoryStructure<?> inventory, CanonicalPath rootPath, boolean computeIdentity, boolean computeContent, boolean computeSync, final Consumer<IntermediateHashContext> onStartChild, final BiConsumer<IntermediateHashContext, IntermediateHashResult> onEndChild) {
        DigestComputingWriter wrt = new DigestComputingWriter(ComputeHash.newDigest());
        HashConstructor ctor = new HashConstructor(wrt){

            @Override
            public void startChild(IntermediateHashContext context) {
                super.startChild(context);
                onStartChild.accept(context);
            }

            @Override
            public void endChild(IntermediateHashContext ctx, IntermediateHashResult result) {
                super.endChild(ctx, result);
                onEndChild.accept(ctx, result);
            }
        };
        return ComputeHash.computeHash(rootPath, inventory.getRoot(), HashableView.of(inventory), ctor, computeIdentity, computeContent, computeSync, rp -> rp.slide(1, 0));
    }

    static IntermediateHashResult computeHash(final CanonicalPath entityPath, Blueprint entity, final HashableView structure, final HashConstructor bld, boolean compIdentity, boolean compContent, boolean compSync, final Function<RelativePath, RelativePath> pathCompleter) {
        Class<AbstractElement<?, ?>> entityType = Inventory.types().byBlueprint(entity.getClass()).getElementType();
        boolean syncable = Syncable.class.isAssignableFrom(entityType);
        boolean identityHashable = IdentityHashable.class.isAssignableFrom(entityType);
        boolean contentHashable = ContentHashable.class.isAssignableFrom(entityType);
        compIdentity = compIdentity || compSync;
        compContent = compContent || compSync;
        final boolean computeIdentity = compIdentity && identityHashable;
        final boolean computeContent = compContent && contentHashable;
        final boolean computeSync = compSync && syncable;
        return entity.accept(new ElementBlueprintVisitor.Simple<IntermediateHashResult, IntermediateHashContext>(){

            @Override
            public IntermediateHashResult visitData(DataEntity.Blueprint<?> data, IntermediateHashContext ctx) {
                return this.wrap(data, ctx, childContext -> {
                    try {
                        StringBuilder json = new StringBuilder();
                        data.getValue().writeJSON(json);
                        if (computeIdentity) {
                            ComputeHash.appendIdentity(data.getId(), childContext);
                            ComputeHash.appendIdentity(json.toString(), childContext);
                        }
                        if (computeContent) {
                            ComputeHash.appendContent(json.toString(), childContext);
                            ComputeHash.appendCommonContent(data, childContext);
                        }
                        if (computeSync) {
                            ComputeHash.appendCommonSync(data, childContext);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Could not write out JSON for hash computation purposes.", e);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitMetricType(MetricType.Blueprint mt, IntermediateHashContext ctx) {
                return this.wrap(mt, ctx, childContext -> {
                    if (computeIdentity) {
                        ComputeHash.appendIdentity(mt.getId(), childContext);
                        ComputeHash.appendIdentity(mt.getMetricDataType().name(), childContext);
                        ComputeHash.appendIdentity(mt.getUnit().name(), childContext);
                    }
                    if (computeContent) {
                        ComputeHash.appendContent(mt.getMetricDataType().name(), childContext);
                        ComputeHash.appendContent(mt.getUnit().name(), childContext);
                        ComputeHash.appendContent(Objects.toString(mt.getCollectionInterval(), ""), childContext);
                        ComputeHash.appendCommonContent(mt, childContext);
                    }
                    if (computeSync) {
                        ComputeHash.appendCommonSync(mt, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitOperationType(OperationType.Blueprint operationType, IntermediateHashContext ctx) {
                return this.wrap(operationType, ctx, childContext -> {
                    if (computeIdentity) {
                        this.appendEntityIdentity(structure.getReturnType(ctx.root, operationType), (IntermediateHashContext)childContext);
                        this.appendEntityIdentity(structure.getParameterTypes(ctx.root, operationType), (IntermediateHashContext)childContext);
                        ComputeHash.appendIdentity(operationType.getId(), childContext);
                    }
                    if (computeContent) {
                        ComputeHash.appendCommonContent(operationType, childContext);
                    }
                    if (computeSync) {
                        ComputeHash.appendCommonSync(operationType, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitResourceType(ResourceType.Blueprint type, IntermediateHashContext ctx) {
                return this.wrap(type, ctx, childContext -> {
                    if (computeIdentity) {
                        this.appendEntityIdentity(structure.getConfigurationSchema(type), (IntermediateHashContext)childContext);
                        this.appendEntityIdentity(structure.getConnectionConfigurationSchema(type), (IntermediateHashContext)childContext);
                        structure.getOperationTypes(type).forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        ComputeHash.appendIdentity(type.getId(), childContext);
                    }
                    if (computeContent) {
                        ComputeHash.appendCommonContent(type, childContext);
                    }
                    if (computeSync) {
                        ComputeHash.appendCommonSync(type, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitFeed(Feed.Blueprint feed, IntermediateHashContext ctx) {
                return this.wrap(feed, ctx, childContext -> {
                    if (computeIdentity) {
                        structure.getResourceTypes().forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        structure.getMetricTypes().forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        structure.getFeedResources().forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        structure.getFeedMetrics().forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        ComputeHash.appendIdentity(feed.getId(), childContext);
                    }
                    if (computeContent) {
                        ComputeHash.appendCommonContent(feed, childContext);
                    }
                    if (computeSync) {
                        ComputeHash.appendCommonSync(feed, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitMetric(Metric.Blueprint metric, IntermediateHashContext ctx) {
                return this.wrap(metric, ctx, childContext -> {
                    if (computeIdentity) {
                        ComputeHash.appendIdentity(metric.getId(), childContext);
                    }
                    if (computeContent) {
                        RelativePath mtPath = this.relativize(metric.getMetricTypePath(), SegmentType.mt, (IntermediateHashContext)childContext);
                        ComputeHash.appendContent(mtPath.toString(), childContext);
                        ComputeHash.appendContent(Objects.toString(metric.getCollectionInterval(), ""), childContext);
                        ComputeHash.appendCommonContent(metric, childContext);
                    }
                    if (computeSync) {
                        ComputeHash.appendCommonSync(metric, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitResource(Resource.Blueprint resource, IntermediateHashContext context) {
                return this.wrap(resource, context, childContext -> {
                    if (computeIdentity) {
                        this.appendEntityIdentity(structure.getConfiguration(context.root, resource), (IntermediateHashContext)childContext);
                        this.appendEntityIdentity(structure.getConnectionConfiguration(context.root, resource), (IntermediateHashContext)childContext);
                        structure.getResources(context.root, resource).forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        structure.getResourceMetrics(context.root, resource).forEach(b -> this.appendEntityIdentity((Entity.Blueprint)b, (IntermediateHashContext)childContext));
                        ComputeHash.appendIdentity(resource.getId(), childContext);
                    }
                    if (computeContent) {
                        RelativePath rtPath = this.relativize(resource.getResourceTypePath(), SegmentType.rt, (IntermediateHashContext)childContext);
                        ComputeHash.appendContent(rtPath.toString(), childContext);
                        ComputeHash.appendCommonContent(resource, childContext);
                    }
                    if (computeSync) {
                        ComputeHash.appendCommonSync(resource, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitTenant(Tenant.Blueprint tenant, IntermediateHashContext context) {
                return this.wrap(tenant, context, childContext -> {
                    if (computeContent) {
                        ComputeHash.appendCommonContent(tenant, childContext);
                    }
                });
            }

            @Override
            public IntermediateHashResult visitEnvironment(Environment.Blueprint environment, IntermediateHashContext context) {
                return this.wrap(environment, context, childContext -> {
                    if (computeContent) {
                        ComputeHash.appendCommonContent(environment, childContext);
                    }
                });
            }

            private RelativePath relativize(String relativePath, SegmentType targetType, IntermediateHashContext ctx) {
                Path targetPath = Path.fromPartiallyUntypedString((String)relativePath, (CanonicalPath)((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(entityPath.ids().getTenantId())).get()), (CanonicalPath)entityPath, (SegmentType)targetType);
                if (targetPath.isCanonical()) {
                    targetPath = targetPath.toCanonicalPath().relativeTo(entityPath);
                }
                return targetPath.toRelativePath();
            }

            private IntermediateHashResult wrap(Entity.Blueprint root, IntermediateHashContext context, Consumer<IntermediateHashContext> hashComputation) {
                IntermediateHashContext childCtx = context.progress(root);
                bld.startChild(childCtx);
                hashComputation.accept(childCtx);
                String identityHash = null;
                String contentHash = null;
                String syncHash = null;
                DigestComputingWriter digestor = bld.getDigestor();
                if (computeIdentity) {
                    digestor.reset();
                    digestor.append(childCtx.identity);
                    digestor.close();
                    identityHash = digestor.digest();
                }
                if (computeContent) {
                    digestor.reset();
                    digestor.append(childCtx.content);
                    digestor.close();
                    contentHash = digestor.digest();
                }
                if (computeSync) {
                    digestor.reset();
                    digestor.append(identityHash);
                    digestor.append(contentHash);
                    digestor.append(childCtx.sync);
                    digestor.close();
                    syncHash = digestor.digest();
                }
                IntermediateHashResult ret = pathCompleter == null ? new IntermediateHashResult(null, identityHash, contentHash, syncHash) : new IntermediateHashResult((RelativePath)pathCompleter.apply(childCtx.root), identityHash, contentHash, syncHash);
                bld.endChild(childCtx, ret);
                return ret;
            }

            private void appendEntityIdentity(Entity.Blueprint child, IntermediateHashContext ctx) {
                ctx.identity.append(child.accept(this, ctx).identityHash);
            }
        }, new IntermediateHashContext(RelativePath.empty().get()));
    }

    static void appendIdentity(String data, IntermediateHashContext ctx) {
        if (data != null) {
            ctx.identity.append(data);
        }
    }

    static void appendContent(String data, IntermediateHashContext ctx) {
        if (data != null) {
            ctx.content.append(data);
        }
    }

    static void appendContent(Map<String, Object> props, IntermediateHashContext ctx) {
        if (props == null) {
            return;
        }
        TreeMap sorted = new TreeMap(Comparator.naturalOrder());
        sorted.putAll(props);
        for (Map.Entry e : sorted.entrySet()) {
            ctx.content.append((String)e.getKey()).append(e.getValue());
        }
    }

    static void appendCommonContent(Entity.Blueprint b, IntermediateHashContext ctx) {
        ComputeHash.appendContent(b.getName(), ctx);
        ComputeHash.appendContent(b.getProperties(), ctx);
    }

    static void appendSync(String data, IntermediateHashContext ctx) {
        if (data != null) {
            ctx.sync.append(data);
        }
    }

    static void appendCommonSync(Entity.Blueprint bl, IntermediateHashContext ctx) {
    }

    static class HashConstructor {
        private final DigestComputingWriter digestor;

        HashConstructor(DigestComputingWriter digestor) {
            this.digestor = digestor;
        }

        public DigestComputingWriter getDigestor() {
            return this.digestor;
        }

        public void startChild(IntermediateHashContext context) {
        }

        public void endChild(IntermediateHashContext ctx, IntermediateHashResult result) {
        }
    }

    static class IntermediateHashResult {
        final RelativePath path;
        final String identityHash;
        final String contentHash;
        final String syncHash;

        private IntermediateHashResult(RelativePath path, String identityHash, String contentHash, String syncHash) {
            this.path = path;
            this.identityHash = identityHash;
            this.contentHash = contentHash;
            this.syncHash = syncHash;
        }
    }

    static class IntermediateHashContext {
        final RelativePath root;
        final StringBuilder identity = new StringBuilder();
        final StringBuilder content = new StringBuilder();
        final StringBuilder sync = new StringBuilder();

        IntermediateHashContext(RelativePath root) {
            this.root = root;
        }

        IntermediateHashContext progress(Entity.Blueprint bl) {
            return new IntermediateHashContext(this.root.modified().extend(Blueprint.getSegmentTypeOf(bl), bl.getId()).get());
        }
    }

    static class DigestComputingWriter
    implements Appendable,
    Closeable {
        private final MessageDigest digester;
        private final CharsetEncoder enc = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        private final ByteBuffer buffer = ByteBuffer.allocate(512);
        private String digest;

        DigestComputingWriter(MessageDigest digester) {
            this.digester = digester;
        }

        @Override
        public DigestComputingWriter append(CharSequence csq) {
            this.consumeBuffer(CharBuffer.wrap(csq));
            return this;
        }

        @Override
        public DigestComputingWriter append(CharSequence csq, int start, int end) {
            this.consumeBuffer(CharBuffer.wrap(csq, start, end));
            return this;
        }

        @Override
        public DigestComputingWriter append(char c) {
            this.consumeBuffer(CharBuffer.wrap(new char[]{c}));
            return this;
        }

        @Override
        public void close() {
            this.digest = this.runningDigest();
        }

        String runningDigest() {
            byte[] digest = this.digester.digest();
            StringBuilder bld = new StringBuilder();
            for (byte b : digest) {
                bld.append(Integer.toHexString(Byte.toUnsignedInt(b)));
            }
            return bld.toString();
        }

        String digest() {
            if (this.digest == null) {
                throw new IllegalStateException("digest computing writer not closed.");
            }
            return this.digest;
        }

        public void reset() {
            this.digester.reset();
            this.digest = null;
        }

        private void consumeBuffer(CharBuffer chars) {
            CoderResult res;
            do {
                res = this.enc.encode(chars, this.buffer, true);
                this.buffer.flip();
                this.digester.update(this.buffer);
                this.buffer.clear();
            } while (res == CoderResult.OVERFLOW);
        }
    }

    public static final class Tree {
        private Tree() {
        }
    }

    static interface HashableView {
        public static HashableView of(final MetadataPack.Members members) {
            return new HashableView(){

                @Override
                public List<ResourceType.Blueprint> getResourceTypes() {
                    return members.getResourceTypes();
                }

                @Override
                public List<MetricType.Blueprint> getMetricTypes() {
                    return members.getMetricTypes();
                }

                @Override
                public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint resourceType) {
                    ArrayList<OperationType.Blueprint> ret = new ArrayList<OperationType.Blueprint>(members.getOperationTypes(resourceType));
                    Collections.sort(ret, BLUEPRINT_COMPARATOR);
                    return ret;
                }

                @Override
                public DataEntity.Blueprint<?> getReturnType(RelativePath resourceType, OperationType.Blueprint operationType) {
                    return members.getReturnType(operationType);
                }

                @Override
                public DataEntity.Blueprint<?> getParameterTypes(RelativePath resourceType, OperationType.Blueprint operationType) {
                    return members.getParameterTypes(operationType);
                }

                @Override
                public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
                    return members.getConfigurationSchema(rt);
                }

                @Override
                public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
                    return members.getConnectionConfigurationSchema(rt);
                }
            };
        }

        public static HashableView of(final InventoryStructure<?> structure) {
            return new HashableView(){

                @Override
                public DataEntity.Blueprint<?> getConfiguration(RelativePath rootPath, Resource.Blueprint parentResource) {
                    RelativePath resourcePath = rootPath.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    try (Stream s = structure.getChildren(resourcePath, DataEntity.class);){
                        DataEntity.Blueprint blueprint = s.filter(d -> DataRole.Resource.configuration.equals(d.getRole())).findFirst().orElse(ComputeHash.dummyDataBlueprint((DataRole)DataRole.Resource.configuration));
                        return blueprint;
                    }
                }

                @Override
                public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
                    RelativePath p = rt.equals(structure.getRoot()) ? RelativePath.empty().get() : (RelativePath)RelativePath.to().resourceType(rt.getId()).get();
                    try (Stream<DataEntity.Blueprint> s = structure.getChildren(p, DataEntity.class).filter(d -> DataRole.ResourceType.configurationSchema.equals(d.getRole()));){
                        DataEntity.Blueprint blueprint = s.findFirst().orElse(ComputeHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.configurationSchema));
                        return blueprint;
                    }
                }

                @Override
                public DataEntity.Blueprint<?> getConnectionConfiguration(RelativePath root, Resource.Blueprint parentResource) {
                    RelativePath resourcePath = root.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    try (Stream<DataEntity.Blueprint> s = structure.getChildren(resourcePath, DataEntity.class).filter(d -> DataRole.Resource.connectionConfiguration.equals(d.getRole()));){
                        DataEntity.Blueprint blueprint = s.findFirst().orElse(ComputeHash.dummyDataBlueprint((DataRole)DataRole.Resource.connectionConfiguration));
                        return blueprint;
                    }
                }

                @Override
                public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
                    RelativePath p = rt.equals(structure.getRoot()) ? RelativePath.empty().get() : (RelativePath)RelativePath.to().resourceType(rt.getId()).get();
                    try (Stream<DataEntity.Blueprint> s = structure.getChildren(p, DataEntity.class).filter(d -> DataRole.ResourceType.connectionConfigurationSchema.equals(d.getRole()));){
                        DataEntity.Blueprint blueprint = s.findFirst().orElse(ComputeHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.connectionConfigurationSchema));
                        return blueprint;
                    }
                }

                @Override
                public List<Metric.Blueprint> getFeedMetrics() {
                    try (Stream s = structure.getChildren(RelativePath.empty().get(), Metric.class);){
                        List<Metric.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public List<Resource.Blueprint> getFeedResources() {
                    try (Stream s = structure.getChildren(RelativePath.empty().get(), Resource.class);){
                        List<Resource.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public List<MetricType.Blueprint> getMetricTypes() {
                    try (Stream s = structure.getChildren(RelativePath.empty().get(), MetricType.class);){
                        List<MetricType.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint rt) {
                    RelativePath p = rt.equals(structure.getRoot()) ? RelativePath.empty().get() : (RelativePath)RelativePath.to().resourceType(rt.getId()).get();
                    try (Stream s = structure.getChildren(p, OperationType.class);){
                        List<OperationType.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public DataEntity.Blueprint<?> getParameterTypes(RelativePath rootResourceType, OperationType.Blueprint ot) {
                    RelativePath p = rootResourceType.modified().extend(SegmentType.ot, ot.getId()).get().slide(1, 0);
                    try (Stream<DataEntity.Blueprint> s = structure.getChildren(p, DataEntity.class).filter(d -> DataRole.OperationType.parameterTypes.equals(d.getRole()));){
                        DataEntity.Blueprint blueprint = s.findFirst().orElse(ComputeHash.dummyDataBlueprint((DataRole)DataRole.OperationType.parameterTypes));
                        return blueprint;
                    }
                }

                @Override
                public List<Metric.Blueprint> getResourceMetrics(RelativePath rootPath, Resource.Blueprint parentResource) {
                    RelativePath p = rootPath.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    try (Stream s = structure.getChildren(p, Metric.class);){
                        List<Metric.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public List<Resource.Blueprint> getResources(RelativePath rootPath, Resource.Blueprint parentResource) {
                    RelativePath p = rootPath.modified().extend(SegmentType.r, parentResource.getId()).get().slide(1, 0);
                    try (Stream s = structure.getChildren(p, Resource.class);){
                        List<Resource.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public List<ResourceType.Blueprint> getResourceTypes() {
                    try (Stream s = structure.getChildren(RelativePath.empty().get(), ResourceType.class);){
                        List<ResourceType.Blueprint> list = s.collect(Collectors.toList());
                        return list;
                    }
                }

                @Override
                public DataEntity.Blueprint<?> getReturnType(RelativePath rootResourceType, OperationType.Blueprint ot) {
                    RelativePath p = rootResourceType.modified().extend(SegmentType.ot, ot.getId()).get().slide(1, 0);
                    try (Stream<DataEntity.Blueprint> s = structure.getChildren(p, DataEntity.class).filter(d -> DataRole.OperationType.returnType.equals(d.getRole()));){
                        DataEntity.Blueprint blueprint = s.findFirst().orElse(ComputeHash.dummyDataBlueprint((DataRole)DataRole.OperationType.returnType));
                        return blueprint;
                    }
                }
            };
        }

        default public List<ResourceType.Blueprint> getResourceTypes() {
            return Collections.emptyList();
        }

        default public List<MetricType.Blueprint> getMetricTypes() {
            return Collections.emptyList();
        }

        default public List<OperationType.Blueprint> getOperationTypes(ResourceType.Blueprint rt) {
            return Collections.emptyList();
        }

        default public DataEntity.Blueprint<?> getReturnType(RelativePath rootResourceType, OperationType.Blueprint ot) {
            return ComputeHash.dummyDataBlueprint((DataRole)DataRole.OperationType.returnType);
        }

        default public DataEntity.Blueprint<?> getParameterTypes(RelativePath rootResourceType, OperationType.Blueprint ot) {
            return ComputeHash.dummyDataBlueprint((DataRole)DataRole.OperationType.parameterTypes);
        }

        default public DataEntity.Blueprint<?> getConfigurationSchema(ResourceType.Blueprint rt) {
            return ComputeHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.configurationSchema);
        }

        default public DataEntity.Blueprint<?> getConnectionConfigurationSchema(ResourceType.Blueprint rt) {
            return ComputeHash.dummyDataBlueprint((DataRole)DataRole.ResourceType.connectionConfigurationSchema);
        }

        default public List<Resource.Blueprint> getResources(RelativePath rootPath, Resource.Blueprint parentResource) {
            return Collections.emptyList();
        }

        default public List<Resource.Blueprint> getFeedResources() {
            return Collections.emptyList();
        }

        default public List<Metric.Blueprint> getFeedMetrics() {
            return Collections.emptyList();
        }

        default public List<Metric.Blueprint> getResourceMetrics(RelativePath rootPath, Resource.Blueprint parentResource) {
            return Collections.emptyList();
        }

        default public DataEntity.Blueprint<?> getConfiguration(RelativePath rootPath, Resource.Blueprint parentResource) {
            return ComputeHash.dummyDataBlueprint((DataRole)DataRole.Resource.configuration);
        }

        default public DataEntity.Blueprint<?> getConnectionConfiguration(RelativePath root, Resource.Blueprint parentResource) {
            return ComputeHash.dummyDataBlueprint((DataRole)DataRole.Resource.connectionConfiguration);
        }
    }
}

