/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.security.messaging.impl.BaseClientCertAuthSecurityHandler;

public class SAMLMDClientCertAuthSecurityHandler
extends BaseClientCertAuthSecurityHandler {
    @Nonnull
    protected CriteriaSet buildCriteriaSet(@Nullable String entityID, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = super.buildCriteriaSet(entityID, messageContext);
        try {
            SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
            Constraint.isNotNull((Object)peerEntityContext, (String)"SAMLPeerEntityContext was null");
            Constraint.isNotNull((Object)peerEntityContext.getRole(), (String)"SAML peer role was null");
            criteriaSet.add((Object)new EntityRoleCriterion(peerEntityContext.getRole()));
            SAMLProtocolContext protocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class);
            Constraint.isNotNull((Object)protocolContext, (String)"SAMLProtocolContext was null");
            Constraint.isNotNull((Object)protocolContext.getProtocol(), (String)"SAML protocol was null");
            criteriaSet.add((Object)new ProtocolCriterion(protocolContext.getProtocol()));
        }
        catch (ConstraintViolationException e) {
            throw new MessageHandlerException((Exception)((Object)e));
        }
        return criteriaSet;
    }

    @Nullable
    protected String getCertificatePresenterEntityID(@Nonnull MessageContext messageContext) {
        return ((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getEntityId();
    }

    protected void setAuthenticatedCertificatePresenterEntityID(@Nonnull MessageContext messageContext, @Nullable String entityID) {
        ((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(entityID);
    }

    protected void setAuthenticatedState(@Nonnull MessageContext messageContext, boolean authenticated) {
        ((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setAuthenticated(authenticated);
    }
}

