/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.spring;

import javax.servlet.ServletContext;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.plugins.spring.SpringBeanProcessor;
import org.jboss.resteasy.plugins.spring.i18n.Messages;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class SpringContextLoaderSupport {
    public void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        if (providerFactory == null) {
            throw new RuntimeException(Messages.MESSAGES.providerFactoryIsNull());
        }
        Registry registry = (Registry)servletContext.getAttribute(Registry.class.getName());
        if (registry == null) {
            throw new RuntimeException(Messages.MESSAGES.registryIsNull());
        }
        Dispatcher dispatcher = (Dispatcher)servletContext.getAttribute(Dispatcher.class.getName());
        if (dispatcher == null) {
            throw new RuntimeException(Messages.MESSAGES.dispatcherIsNull());
        }
        SpringBeanProcessor processor = new SpringBeanProcessor(dispatcher, registry, providerFactory);
        configurableWebApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)processor);
        configurableWebApplicationContext.addApplicationListener((ApplicationListener)processor);
    }
}

