/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.exception.SearchException;

public class EntityDescriptor {
    private Map<String, Object> indexed;
    private final Map<PropertyKey, PropertyDescriptor> properties = new HashMap<PropertyKey, PropertyDescriptor>();
    private Map<String, Object> boost;
    private Map<String, Object> analyzerDiscriminator;
    private final Set<Map<String, Object>> fullTextFilterDefs = new HashSet<Map<String, Object>>();
    private Map<String, Object> providedId;
    private final Set<Map<String, Object>> classBridges = new HashSet<Map<String, Object>>();
    private final Map<FieldBridge, Map<String, Object>> classBridgeInstanceDefs = new IdentityHashMap<FieldBridge, Map<String, Object>>();
    private final Map<FieldBridge, ClassBridge> classBridgeConfigurations = new IdentityHashMap<FieldBridge, ClassBridge>();
    private final Set<Map<String, Object>> spatials = new HashSet<Map<String, Object>>();
    private Map<String, Object> dynamicBoost;

    public Map<String, Object> getIndexed() {
        return this.indexed;
    }

    public void setIndexed(Map<String, Object> indexed) {
        this.indexed = indexed;
    }

    PropertyDescriptor getProperty(String name, ElementType type) {
        PropertyKey propertyKey = new PropertyKey(name, type);
        PropertyDescriptor descriptor = this.properties.get(propertyKey);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor(name, type);
            this.properties.put(propertyKey, descriptor);
        }
        return descriptor;
    }

    public PropertyDescriptor getPropertyDescriptor(String name, ElementType type) {
        return this.properties.get(new PropertyKey(name, type));
    }

    @Deprecated
    public Map<String, Object> getCacheInMemory() {
        return Collections.emptyMap();
    }

    @Deprecated
    public void setCacheInMemory(Map<String, Object> cacheInMemory) {
    }

    public void setBoost(Map<String, Object> boost) {
        this.boost = boost;
    }

    public Map<String, Object> getBoost() {
        return this.boost;
    }

    public void setAnalyzerDiscriminator(Map<String, Object> analyzerDiscriminator) {
        this.analyzerDiscriminator = analyzerDiscriminator;
    }

    public Map<String, Object> getAnalyzerDiscriminator() {
        return this.analyzerDiscriminator;
    }

    public Set<Map<String, Object>> getFullTextFilterDefs() {
        return this.fullTextFilterDefs;
    }

    public void addFulltextFilterDef(Map<String, Object> fullTextFilterDef) {
        this.fullTextFilterDefs.add(fullTextFilterDef);
    }

    public void addClassBridgeDef(Map<String, Object> classBridge) {
        this.classBridges.add(classBridge);
    }

    public void addClassBridgeInstanceDef(FieldBridge classBridge, Map<String, Object> properties) {
        Map<String, Object> previous = this.classBridgeInstanceDefs.put(classBridge, properties);
        if (previous != null) {
            throw new SearchException("The same field bridge instance must not be passed more than once.");
        }
    }

    public Set<Map<String, Object>> getClassBridgeDefs() {
        return this.classBridges;
    }

    public Map<FieldBridge, Map<String, Object>> getClassBridgeInstanceDefs() {
        return this.classBridgeInstanceDefs;
    }

    public void addClassBridgeInstanceConfiguration(FieldBridge classBridge, ClassBridge configuration) {
        this.classBridgeConfigurations.put(classBridge, configuration);
    }

    public Map<FieldBridge, ClassBridge> getClassBridgeConfigurations() {
        return this.classBridgeConfigurations;
    }

    public void addSpatial(Map<String, Object> spatial) {
        this.spatials.add(spatial);
    }

    public Set<Map<String, Object>> getSpatials() {
        return this.spatials;
    }

    public void setProvidedId(Map<String, Object> providedId) {
        this.providedId = providedId;
    }

    public Map<String, Object> getProvidedId() {
        return this.providedId;
    }

    public void setDynamicBoost(Map<String, Object> dynamicEntityBoost) {
        this.dynamicBoost = dynamicEntityBoost;
    }

    public Map<String, Object> getDynamicBoost() {
        return this.dynamicBoost;
    }

    private static class PropertyKey {
        private final String name;
        private final ElementType type;

        PropertyKey(String name, ElementType type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyKey property = (PropertyKey)o;
            if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
                return false;
            }
            return this.type == property.type;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

