/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.ForkProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ForkResourceDefinition
extends ChildResourceDefinition {
    public static final PathElement WILDCARD_PATH = ForkResourceDefinition.pathElement("*");
    private final ResourceServiceBuilderFactory<ChannelFactory> builderFactory = new ForkChannelFactoryBuilderFactory();
    final boolean allowRuntimeOnlyRegistration;

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"fork", (String)name);
    }

    ForkResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH));
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver());
        ForkServiceHandler handler = new ForkServiceHandler(this.builderFactory);
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler){

            protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                super.performRemove(context, operation, model);
                if (ForkResourceDefinition.this.allowRuntimeOnlyRegistration && context.getRunningMode() == RunningMode.NORMAL) {
                    Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                    for (Resource.ResourceEntry entry : resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{entry.getPathElement()}));
                    }
                    context.getResourceRegistrationForUpdate().unregisterOverrideModel(context.getCurrentAddressValue());
                }
            }
        }.register(registration);
        new ForkProtocolResourceDefinition(this.builderFactory, this.allowRuntimeOnlyRegistration).register(registration);
    }
}

