/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.plugins.RxJavaPlugins;

public final class OperatorOnErrorResumeNextViaObservable<T>
implements Observable.Operator<T, T> {
    final Observable<? extends T> resumeSequence;

    public OperatorOnErrorResumeNextViaObservable(Observable<? extends T> resumeSequence) {
        this.resumeSequence = resumeSequence;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber s = new Subscriber<T>(){
            private boolean done = false;

            @Override
            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                child.onNext(t);
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    Exceptions.throwIfFatal(e);
                    return;
                }
                this.done = true;
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                this.unsubscribe();
                OperatorOnErrorResumeNextViaObservable.this.resumeSequence.unsafeSubscribe(child);
            }

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                child.onCompleted();
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){

                    @Override
                    public void request(long n) {
                        producer.request(n);
                    }
                });
            }
        };
        child.add(s);
        return s;
    }
}

