/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.Wss10;

public class Wss11
extends Wss10 {
    private boolean mustSupportRefThumbprint;
    private boolean mustSupportRefEncryptedKey;
    private boolean requireSignatureConfirmation;

    public Wss11(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version, nestedPolicy);
        this.parseNestedWss11Policy(nestedPolicy, this);
    }

    @Override
    public QName getName() {
        return this.getVersion().getSPConstants().getWss11();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new Wss11(this.getVersion(), nestedPolicy);
    }

    protected void parseNestedWss11Policy(Policy nestedPolicy, Wss11 wss11) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (this.getVersion().getSPConstants().getMustSupportRefThumbprint().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportRefThumbprint().getNamespaceURI().equals(assertionNamespace)) {
                    if (wss11.isMustSupportRefThumbprint()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    wss11.setMustSupportRefThumbprint(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getMustSupportRefEncryptedKey().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportRefEncryptedKey().getNamespaceURI().equals(assertionNamespace)) {
                    if (wss11.isMustSupportRefEncryptedKey()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    wss11.setMustSupportRefEncryptedKey(true);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getRequireSignatureConfirmation().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getRequireSignatureConfirmation().getNamespaceURI().equals(assertionNamespace)) continue;
                if (wss11.isRequireSignatureConfirmation()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                wss11.setRequireSignatureConfirmation(true);
            }
        }
    }

    public boolean isMustSupportRefThumbprint() {
        return this.mustSupportRefThumbprint;
    }

    protected void setMustSupportRefThumbprint(boolean mustSupportRefThumbprint) {
        this.mustSupportRefThumbprint = mustSupportRefThumbprint;
    }

    public boolean isMustSupportRefEncryptedKey() {
        return this.mustSupportRefEncryptedKey;
    }

    protected void setMustSupportRefEncryptedKey(boolean mustSupportRefEncryptedKey) {
        this.mustSupportRefEncryptedKey = mustSupportRefEncryptedKey;
    }

    public boolean isRequireSignatureConfirmation() {
        return this.requireSignatureConfirmation;
    }

    protected void setRequireSignatureConfirmation(boolean requireSignatureConfirmation) {
        this.requireSignatureConfirmation = requireSignatureConfirmation;
    }
}

