/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.Arrays;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.model.Entity;

public final class RelationWith {
    private RelationWith() {
    }

    public static Ids id(String id) {
        return new Ids(id);
    }

    public static Ids ids(String ... ids) {
        return new Ids(ids);
    }

    public static PropertyValues property(String property) {
        return new PropertyValues(property, new Object[0]);
    }

    public static PropertyValues propertyValue(String property, Object value) {
        return new PropertyValues(property, value);
    }

    @SafeVarargs
    public static PropertyValues propertyValues(String property, Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("there must be at least one value of the property");
        }
        PropertyValues properties = new PropertyValues(property, values);
        return properties;
    }

    public static PropertyValues name(String value) {
        return new PropertyValues("label", value);
    }

    @SafeVarargs
    public static PropertyValues names(String ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("there must be at least one value of the relation name");
        }
        PropertyValues names = new PropertyValues("label", values);
        return names;
    }

    @SafeVarargs
    public static SourceOfType sourcesOfTypes(Class<? extends Entity<?, ?>> ... types) {
        return new SourceOfType(types);
    }

    public static SourceOfType sourceOfType(Class<? extends Entity<?, ?>> type) {
        return new SourceOfType(type);
    }

    @SafeVarargs
    public static TargetOfType targetsOfTypes(Class<? extends Entity<?, ?>> ... types) {
        return new TargetOfType(types);
    }

    public static TargetOfType targetOfType(Class<? extends Entity<?, ?>> type) {
        return new TargetOfType(type);
    }

    public static final class TargetOfType
    extends SourceOrTargetOfType {
        @SafeVarargs
        public TargetOfType(Class<? extends Entity<?, ?>> ... types) {
            super(types);
        }

        @Override
        public String getFilterName() {
            return "TargetOfType";
        }
    }

    public static final class SourceOfType
    extends SourceOrTargetOfType {
        @SafeVarargs
        public SourceOfType(Class<? extends Entity<?, ?>> ... types) {
            super(types);
        }

        @Override
        public String getFilterName() {
            return "SourceOfType";
        }
    }

    public static class SourceOrTargetOfType
    extends RelationFilter {
        private final Class<? extends Entity<?, ?>>[] types;

        public String getFilterName() {
            return "SourceOrTargetOfType";
        }

        @SafeVarargs
        public SourceOrTargetOfType(Class<? extends Entity<?, ?>> ... types) {
            this.types = types;
        }

        public Class<? extends Entity<?, ?>>[] getTypes() {
            return this.types;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder(this.getFilterName() + "[");
            if (this.types.length > 0) {
                ret.append(this.types[0].getSimpleName());
                for (int i = 1; i < this.types.length; ++i) {
                    ret.append(", ").append(this.types[i].getSimpleName());
                }
            }
            ret.append("]");
            return ret.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceOrTargetOfType)) {
                return false;
            }
            SourceOrTargetOfType that = (SourceOrTargetOfType)o;
            return Arrays.equals(this.types, that.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }

    public static final class PropertyValues
    extends RelationFilter {
        private final String property;
        private final Object[] values;

        public PropertyValues(String property, Object ... values) {
            this.property = property;
            this.values = values;
        }

        public String getProperty() {
            return this.property;
        }

        public Object[] getValues() {
            return this.values;
        }

        public String toString() {
            return "RelationshipProperty: " + this.getProperty() + "=" + Arrays.asList(this.values).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyValues)) {
                return false;
            }
            PropertyValues that = (PropertyValues)o;
            return this.property.equals(that.property) && Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            int result = this.property.hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }
    }

    public static final class Ids
    extends RelationFilter {
        private final String[] ids;

        public Ids(String ... ids) {
            this.ids = ids;
        }

        public String[] getIds() {
            return this.ids;
        }

        public String toString() {
            return "RelationshipIds" + Arrays.asList(this.ids).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ids)) {
                return false;
            }
            Ids other = (Ids)o;
            return Arrays.equals(this.ids, other.ids);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ids);
        }
    }
}

