/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.paging;

import java.util.Objects;

public final class Order {
    private final String field;
    private final Direction direction;

    public Order(String field, Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    public static Order by(String field, Direction direction) {
        return new Order(field, direction);
    }

    public static Order unspecified() {
        return new Order(null, Direction.ASCENDING);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getField() {
        return this.field;
    }

    public boolean isSpecific() {
        return this.field != null;
    }

    public boolean isAscending() {
        return this.direction == Direction.ASCENDING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.field, order.field) && this.direction == order.direction;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.direction.hashCode();
        return result;
    }

    public String toString() {
        return "Order[direction=" + (Object)((Object)this.direction) + ", field='" + this.field + '\'' + ']';
    }

    public static enum Direction {
        ASCENDING("asc"),
        DESCENDING("desc");

        private final String shortString;

        private Direction(String shortString) {
            this.shortString = shortString;
        }

        public static Direction fromShortString(String shortString) {
            switch (shortString) {
                case "asc": {
                    return ASCENDING;
                }
                case "desc": {
                    return DESCENDING;
                }
            }
            throw new IllegalArgumentException("Unkown short ordering direction representation: " + shortString);
        }

        public String getShortString() {
            return this.shortString;
        }
    }
}

