/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.UndefinedAttributesDiscardPolicy;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;

public enum ThreadPoolResourceDefinition implements ResourceDefinition,
Registration<ManagementResourceRegistration>,
ThreadPoolDefinition
{
    ASYNC_OPERATIONS("async-operations", 25, 25, 1000, 60000L),
    LISTENER("listener", 1, 1, 100000, 60000L),
    PERSISTENCE("persistence", 1, 4, 0, 60000L),
    REMOTE_COMMAND("remote-command", 1, 200, 0, 60000L),
    STATE_TRANSFER("state-transfer", 1, 60, 0, 60000L),
    TRANSPORT("transport", 25, 25, 100000, 60000L);

    static final PathElement WILDCARD_PATH;
    private final String name;
    private final ResourceDescriptionResolver descriptionResolver;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute queueLength;
    private final Attribute keepAliveTime;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepaliveTime) {
        this.name = name;
        this.descriptionResolver = new InfinispanResourceDescriptionResolver(ThreadPoolResourceDefinition.pathElement(name), ThreadPoolResourceDefinition.pathElement("*"));
        this.minThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.queueLength = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("queue-length", ModelType.INT, new ModelNode(defaultQueueLength), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepaliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L)).build());
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder) {
        return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null))).setValidator(validatorBuilder.allowExpression(true).allowUndefined(true).build());
    }

    public PathElement getPathElement() {
        return ThreadPoolResourceDefinition.pathElement(this.name);
    }

    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration registration) {
        return new DefaultResourceDescriptionProvider(registration, this.descriptionResolver);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        ResourceDescriptor descriptor = new ResourceDescriptor(this.descriptionResolver).addAttributes(this.getAttributes());
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new ThreadPoolBuilderFactory(this));
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
    }

    public void registerNotifications(ManagementResourceRegistration registration) {
    }

    public void registerChildren(ManagementResourceRegistration registration) {
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isOrderedChild() {
        return false;
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)this);
    }

    public ServiceName getServiceName(String containerName) {
        return CacheContainerServiceName.CONFIGURATION.getServiceName(containerName).append(this.getPathElement().getKeyValuePair());
    }

    @Override
    public Attribute getMinThreads() {
        return this.minThreads;
    }

    @Override
    public Attribute getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public Attribute getQueueLength() {
        return this.queueLength;
    }

    @Override
    public Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    Collection<Attribute> getAttributes() {
        return Arrays.asList(this.minThreads, this.maxThreads, this.queueLength, this.keepAliveTime);
    }

    void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
    }

    DynamicDiscardPolicy getDiscardPolicy() {
        return new UndefinedAttributesDiscardPolicy(this.getAttributes());
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }
}

