/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.SessionAttributes;

public class FineSessionAttributesFactory
implements SessionAttributesFactory<Object> {
    private static final Object VALUE = new Object();
    private final Cache<SessionAttributeKey, MarshalledValue<Object, MarshallingContext>> cache;
    private final Marshaller<Object, MarshalledValue<Object, MarshallingContext>, MarshallingContext> marshaller;
    private final Predicate<Map.Entry<SessionAttributeKey, MarshalledValue<Object, MarshallingContext>>> invalidAttribute;
    private final boolean requireMarshallable;

    public FineSessionAttributesFactory(Cache<? extends Key<String>, ?> cache, Marshaller<Object, MarshalledValue<Object, MarshallingContext>, MarshallingContext> marshaller, boolean requireMarshallable) {
        this.cache = cache;
        this.marshaller = marshaller;
        this.requireMarshallable = requireMarshallable;
        this.invalidAttribute = entry -> {
            try {
                this.marshaller.read(entry.getValue());
                return false;
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, (String)((SessionAttributeKey)((Object)((Object)entry.getKey()))).getValue(), ((SessionAttributeKey)((Object)((Object)entry.getKey()))).getAttribute());
                return true;
            }
        };
    }

    public Object createValue(String id, Void context) {
        if (this.cache.getAdvancedCache().getGroup(id).entrySet().stream().filter(entry -> entry.getKey() instanceof SessionAttributeKey).anyMatch(this.invalidAttribute)) {
            this.remove(id);
        }
        return VALUE;
    }

    public Object findValue(String id) {
        if (this.cache.getAdvancedCache().getGroup(id).entrySet().stream().filter(entry -> entry.getKey() instanceof SessionAttributeKey).anyMatch(this.invalidAttribute)) {
            this.remove(id);
            return null;
        }
        return VALUE;
    }

    public boolean remove(String id) {
        this.cache.getAdvancedCache().removeGroup(id);
        return true;
    }

    public void evict(String id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).getGroup(id).keySet().stream().filter(key -> key instanceof SessionAttributeKey).forEach(key -> {
            try {
                this.cache.evict((Object)key);
            }
            catch (Throwable e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSessionAttribute(e, id, key.getAttribute());
            }
        });
    }

    @Override
    public SessionAttributes createSessionAttributes(String id, Object value) {
        return new FineSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, this.cache, this.marshaller, this.requireMarshallable);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Object value) {
        return new FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, this.cache, this.marshaller);
    }
}

