/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.api.paging.TransformingPage;
import org.hawkular.inventory.base.BackendTransaction;
import org.hawkular.inventory.base.BasePreCommit;
import org.hawkular.inventory.base.BaseRelationships;
import org.hawkular.inventory.base.BaseTenants;
import org.hawkular.inventory.base.DelegatingInventoryBackend;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.ObservableContext;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionConstructor;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.paths.CanonicalPath;
import rx.Observable;

public abstract class BaseInventory<E>
implements Inventory {
    public static final Configuration.Property TRANSACTION_RETRIES = Configuration.Property.builder().withPropertyNameAndSystemProperty("hawkular.inventory.transaction.retries").withEnvironmentVariables("HAWKULAR_INVENTORY_TRANSACTION_RETRIES").build();
    private InventoryBackend<E> backend;
    private final ObservableContext observableContext;
    private Configuration configuration;
    private TraversalContext<E, Tenant> tenantContext;
    private TraversalContext<E, Relationship> relationshipContext;
    private final TransactionConstructor<E> transactionConstructor;

    protected BaseInventory(BaseInventory<E> orig, InventoryBackend<E> backend, TransactionConstructor<E> transactionConstructor) {
        this.observableContext = orig.observableContext;
        this.configuration = orig.configuration;
        this.backend = backend == null ? orig.backend : backend;
        this.transactionConstructor = transactionConstructor == null ? orig.transactionConstructor : transactionConstructor;
        this.tenantContext = new TraversalContext<Tenant, Tenant>(this, Query.empty(), Query.path().with(With.type(Tenant.class)).get(), this.backend, Tenant.class, this.configuration, this.observableContext, this.transactionConstructor);
        this.relationshipContext = new TraversalContext<Relationship, Relationship>(this, Query.empty(), Query.path().get(), this.backend, Relationship.class, this.configuration, this.observableContext, this.transactionConstructor);
    }

    protected BaseInventory() {
        this.observableContext = new ObservableContext();
        this.transactionConstructor = TransactionConstructor.startInBackend();
    }

    protected BaseInventory(TransactionConstructor<E> txCtor) {
        this.observableContext = new ObservableContext();
        this.transactionConstructor = txCtor;
    }

    protected abstract BaseInventory<E> cloneWith(TransactionConstructor<E> var1);

    protected TransactionConstructor<E> adaptTransactionConstructor(TransactionConstructor<E> txCtor) {
        return txCtor;
    }

    @Override
    public final void initialize(Configuration configuration) {
        this.backend = this.doInitialize(configuration);
        this.tenantContext = new TraversalContext<Tenant, Tenant>(this, Query.empty(), Query.path().with(With.type(Tenant.class)).get(), this.backend, Tenant.class, configuration, this.observableContext, this.transactionConstructor);
        this.relationshipContext = new TraversalContext<Relationship, Relationship>(this, Query.empty(), Query.path().get(), this.backend, Relationship.class, configuration, this.observableContext, this.transactionConstructor);
        this.configuration = configuration;
    }

    @Override
    public TransactionFrame newTransactionFrame() {
        if (this.backend.isPreferringBigTransactions()) {
            return new OneTxTransactionFrame();
        }
        return new ManyTxTransactionFrame();
    }

    BaseInventory<E> keepTransaction(Transaction<E> tx) {
        return this.cloneWith(this.adaptTransactionConstructor((b, p) -> {
            HidingPrecommit precommit = new HidingPrecommit();
            Runnable transferActionsAndNotifs = () -> {
                precommit.getHiddenActions().forEach(tx.getPreCommit()::addAction);
                precommit.getHiddenNotifications().forEach(tx.getPreCommit()::addNotifications);
            };
            return new BackendTransaction(new TransactionIgnoringBackend(tx.directAccess(), transferActionsAndNotifs), precommit);
        }));
    }

    protected abstract InventoryBackend<E> doInitialize(Configuration var1);

    @Override
    public final void close() throws Exception {
        if (this.backend != null) {
            this.backend.close();
            this.backend = null;
        }
    }

    @Override
    public Tenants.ReadWrite tenants() {
        return new BaseTenants.ReadWrite<E>(this.tenantContext);
    }

    @Override
    public Relationships.Read relationships() {
        return new BaseRelationships.Read<E>(this.relationshipContext);
    }

    public InventoryBackend<E> getBackend() {
        return this.backend;
    }

    @Override
    public boolean hasObservers(Interest<?, ?> interest) {
        return this.observableContext.isObserved(interest);
    }

    public <C, V> Observable<C> observable(Interest<C, V> interest) {
        return this.observableContext.getObservableFor(interest);
    }

    @Override
    public InputStream getGraphSON(String tenantId) {
        return this.getBackend().getGraphSON(tenantId);
    }

    public AbstractElement<?, ?> getElement(CanonicalPath path) {
        try {
            E element = this.getBackend().find(path);
            Class<?> type = this.getBackend().extractType(element);
            return (AbstractElement)this.getBackend().convert(element, type);
        }
        catch (ElementNotFoundException e) {
            throw new EntityNotFoundException("No element found on path: " + path.toString());
        }
    }

    @Override
    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath startingPoint, Relationships.Direction direction, Class<T> clazz, String ... relationshipNames) {
        return this.getBackend().getTransitiveClosureOver(startingPoint, direction, clazz, relationshipNames);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <T extends AbstractElement> Page<T> execute(Query query, Class<T> requestedEntity, Pager pager) {
        final InventoryBackend<Object> tx = this.getBackend().startTransaction();
        try {
            return new TransformingPage<T, T>(tx.query(query, pager, e -> (AbstractElement)this.backend.convert(e, requestedEntity), null), Function.identity()){

                @Override
                public void close() {
                    tx.rollback();
                }
            };
        }
        catch (Throwable t) {
            tx.rollback();
            throw t;
        }
    }

    private class ManyTxTransactionFrame
    implements TransactionFrame {
        private Transaction.PreCommit<E> activePrecommit;
        private final TransactionConstructor<E> notifsStashingTxCtor = (b, p) -> {
            if (this.activePrecommit == null) {
                this.activePrecommit = p;
            }
            final HidingPrecommit hidingPrecommit = new HidingPrecommit();
            return new BackendTransaction(new DelegatingInventoryBackend<E>(BaseInventory.this.backend.startTransaction()){

                @Override
                public void commit() throws CommitFailureException {
                    hidingPrecommit.getHiddenActions().forEach(ManyTxTransactionFrame.this.activePrecommit::addAction);
                    hidingPrecommit.getHiddenNotifications().forEach(ManyTxTransactionFrame.this.activePrecommit::addNotifications);
                    super.commit();
                }
            }, hidingPrecommit);
        };

        private ManyTxTransactionFrame() {
        }

        @Override
        public void commit() throws TransactionFrame.CommitException {
            if (this.activePrecommit == null) {
                return;
            }
            Transaction tx = null;
            try {
                tx = BaseInventory.this.tenantContext.startTransaction();
                this.activePrecommit.initialize(BaseInventory.this.keepTransaction(tx), tx);
                for (Consumer action : this.activePrecommit.getActions()) {
                    action.accept(tx);
                }
                tx.directAccess().commit();
            }
            catch (Throwable t) {
                if (tx != null) {
                    tx.directAccess().rollback();
                }
                throw new TransactionFrame.CommitException(t);
            }
            this.activePrecommit.getFinalNotifications().forEach(BaseInventory.this.tenantContext::notifyAll);
        }

        @Override
        public void rollback() {
            this.commit();
        }

        @Override
        public Inventory boundInventory() {
            return BaseInventory.this.cloneWith(BaseInventory.this.adaptTransactionConstructor(this.notifsStashingTxCtor));
        }
    }

    private class OneTxTransactionFrame
    implements TransactionFrame {
        private InventoryBackend<E> activeBackend;
        private Transaction.PreCommit<E> activePrecommit;
        private List<TransactionPayload.Committing<?, E>> committedPayloads = new ArrayList();
        private final TransactionConstructor<E> fakeTxCtor = (b, p) -> {
            if (this.activeBackend == null) {
                this.activeBackend = b.startTransaction();
                this.activePrecommit = p;
            }
            InventoryBackend realBackend = this.activeBackend;
            HidingPrecommit txPrecommit = new HidingPrecommit();
            Runnable onCommit = () -> {
                txPrecommit.getHiddenActions().forEach(this.activePrecommit::addAction);
                txPrecommit.getHiddenNotifications().forEach(this.activePrecommit::addNotifications);
            };
            return new BackendTransaction<E>(new TransactionIgnoringBackend(realBackend, onCommit), txPrecommit){

                @Override
                public void registerCommittedPayload(TransactionPayload.Committing<?, E> committedPayload) {
                    OneTxTransactionFrame.this.committedPayloads.add(committedPayload);
                }
            };
        };

        private OneTxTransactionFrame() {
        }

        @Override
        public void commit() throws TransactionFrame.CommitException {
            Util.onFailureRetry(p -> new BackendTransaction(new TransactionIgnoringBackend(this.activeBackend, null), p), Transaction.Committable.from(BaseInventory.this.adaptTransactionConstructor(this.fakeTxCtor).construct(this.activeBackend, new BasePreCommit())), tx -> {
                this.activePrecommit.initialize(this.boundInventory(), tx);
                this.activePrecommit.getActions().forEach(a -> a.accept(tx));
                this.activeBackend.commit();
                this.activePrecommit.getFinalNotifications().forEach(BaseInventory.this.tenantContext::notifyAll);
                return null;
            }, tx -> {
                this.activePrecommit.reset();
                for (TransactionPayload.Committing p : this.committedPayloads) {
                    Transaction fakeTx = this.fakeTxCtor.construct(this.activeBackend, new Transaction.PreCommit.Simple());
                    fakeTx.getPreCommit().initialize(this.boundInventory(), fakeTx);
                    p.run(fakeTx);
                }
                this.activePrecommit.initialize(this.boundInventory(), tx);
                this.activePrecommit.getActions().forEach(a -> a.accept(tx));
                this.activeBackend.commit();
                this.activePrecommit.getFinalNotifications().forEach(BaseInventory.this.tenantContext::notifyAll);
                return null;
            }, BaseInventory.this.relationshipContext.getTransactionRetriesCount());
        }

        @Override
        public void rollback() {
            BaseInventory.this.backend.rollback();
        }

        @Override
        public Inventory boundInventory() {
            return BaseInventory.this.cloneWith(BaseInventory.this.adaptTransactionConstructor(this.fakeTxCtor));
        }
    }

    private static final class HidingPrecommit<E>
    extends Transaction.PreCommit.Simple<E> {
        private HidingPrecommit() {
        }

        @Override
        public List<Consumer<Transaction<E>>> getActions() {
            return Collections.emptyList();
        }

        @Override
        public List<EntityAndPendingNotifications<E, ?>> getFinalNotifications() {
            return Collections.emptyList();
        }

        public List<EntityAndPendingNotifications<E, ?>> getHiddenNotifications() {
            return super.getFinalNotifications();
        }

        public List<Consumer<Transaction<E>>> getHiddenActions() {
            return super.getActions();
        }
    }

    private static class TransactionIgnoringBackend<E>
    extends DelegatingInventoryBackend<E> {
        private final Runnable onCommit;

        public TransactionIgnoringBackend(InventoryBackend<E> backend, Runnable onCommit) {
            super(backend);
            this.onCommit = onCommit;
        }

        @Override
        public void commit() throws CommitFailureException {
            if (this.onCommit != null) {
                this.onCommit.run();
            }
        }

        @Override
        public void rollback() {
        }

        @Override
        public InventoryBackend<E> startTransaction() {
            return this;
        }
    }
}

