/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.Serializable;
import org.hawkular.inventory.api.model.AbstractHashTree;
import org.hawkular.inventory.paths.Path;

public class GenericHashTreeSerializer<T extends AbstractHashTree<T, H>, H extends Serializable>
extends JsonSerializer<T> {
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        serializers.defaultSerializeField("hash", (Object)value.getHash(), gen);
        gen.writeObjectFieldStart("children");
        for (AbstractHashTree child : value.getChildren()) {
            gen.writeFieldName(GenericHashTreeSerializer.segmentToString(child.getPath().getSegment()));
            this.serialize((T)child, gen, serializers);
        }
        gen.writeEndObject();
        gen.writeEndObject();
    }

    private static String segmentToString(Path.Segment segment) {
        return (segment.getElementType() == null ? "" : segment.getElementType().getSerialized() + ";") + segment.getElementId();
    }
}

