/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versiontwo;

import com.arjuna.ats.jta.utils.XAHelper;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import javax.transaction.xa.Xid;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.IoUtils;

class TransactionRecoverMessageHandler
extends AbstractMessageHandler {
    private static final byte HEADER_TX_RECOVER_RESPONSE = 26;
    private final ExecutorService executorService;
    private final MarshallerFactory marshallerFactory;
    private final EJBRemoteTransactionsRepository transactionsRepository;

    TransactionRecoverMessageHandler(EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, ExecutorService executorService) {
        this.executorService = executorService;
        this.transactionsRepository = transactionsRepository;
        this.marshallerFactory = marshallerFactory;
    }

    @Override
    public void processMessage(ChannelAssociation channelAssociation, InputStream inputStream) throws IOException {
        DataInputStream input = new DataInputStream(inputStream);
        short invocationId = input.readShort();
        String txParentNodeName = input.readUTF();
        int recoveryFlags = input.readInt();
        TxRecoveryTask task = new TxRecoveryTask(channelAssociation, invocationId, txParentNodeName, recoveryFlags);
        if (this.executorService != null) {
            this.executorService.submit(task);
        } else {
            task.run();
        }
    }

    private final class TxRecoveryTask
    implements Runnable {
        private final String txParentNodeName;
        private final short invocationId;
        private final ChannelAssociation channelAssociation;
        private final int recoveryFlags;

        TxRecoveryTask(ChannelAssociation channelAssociation, short invocationId, String txParentNodeName, int recoveryFlags) {
            this.txParentNodeName = txParentNodeName;
            this.invocationId = invocationId;
            this.channelAssociation = channelAssociation;
            this.recoveryFlags = recoveryFlags;
        }

        @Override
        public void run() {
            Xid[] xidsToRecover = new Xid[]{};
            try {
                xidsToRecover = TransactionRecoverMessageHandler.this.transactionsRepository.getXidsToRecoverForParentNode(this.txParentNodeName, this.recoveryFlags);
            }
            catch (Throwable t) {
                try {
                    EjbLogger.REMOTE_LOGGER.errorDuringTransactionRecovery(t);
                    TransactionRecoverMessageHandler.this.writeException(this.channelAssociation, TransactionRecoverMessageHandler.this.marshallerFactory, this.invocationId, t, null);
                }
                catch (IOException e) {
                    EjbLogger.REMOTE_LOGGER.couldNotWriteOutToChannel(e);
                    IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
                }
                return;
            }
            try {
                if (EjbLogger.REMOTE_LOGGER.isTraceEnabled()) {
                    EjbLogger.REMOTE_LOGGER.trace("Returning " + xidsToRecover.length + " Xid(s) to recover for parent node: " + this.txParentNodeName);
                    for (Xid xid : xidsToRecover) {
                        EjbLogger.REMOTE_LOGGER.trace("EJB Xid to recover " + XAHelper.xidToString((Xid)xid));
                    }
                }
                this.writeResponse(xidsToRecover);
            }
            catch (IOException e) {
                EjbLogger.REMOTE_LOGGER.couldNotWriteInvocationSuccessMessage(e);
                IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeResponse(Xid[] xids) throws IOException {
            MessageOutputStream messageOutputStream;
            try {
                messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failedToOpenMessageOutputStream(e);
            }
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)messageOutputStream);
            try {
                dataOutputStream.writeByte(26);
                dataOutputStream.writeShort(this.invocationId);
                PackedInteger.writePackedInteger((DataOutput)dataOutputStream, (int)xids.length);
                if (xids.length > 0) {
                    Marshaller marshaller = TransactionRecoverMessageHandler.this.prepareForMarshalling(TransactionRecoverMessageHandler.this.marshallerFactory, dataOutputStream);
                    for (int i = 0; i < xids.length; ++i) {
                        marshaller.writeObject((Object)new XidTransactionID(xids[i]));
                    }
                    marshaller.finish();
                }
            }
            finally {
                this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                dataOutputStream.close();
            }
        }
    }
}

