/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.jboss.ejb3.Namespace;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.ExtendableMetaDataParser;
import org.jboss.metadata.ejb.spec.ExtendableMetaData;
import org.jboss.metadata.property.PropertyReplacer;

public class ExtendingMetaDataParser<MD extends ExtendableMetaData>
extends AbstractMetaDataParser<MD>
implements AttributeProcessor<MD> {
    private final ExtendableMetaDataParser<MD> delegate;
    private final Map<String, AbstractMetaDataParser<?>> parsers;

    public ExtendingMetaDataParser(ExtendableMetaDataParser<MD> delegate, Map<String, AbstractMetaDataParser<?>> parsers) {
        this.delegate = delegate;
        this.parsers = parsers;
    }

    protected AbstractMetaDataParser<?> getParser(String uri) {
        return ExtendingMetaDataParser.mandatory(this.parsers.get(uri), "No parser found for " + uri);
    }

    private static <V> V mandatory(V value, String message) {
        if (value == null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    @Override
    public MD parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        ExtendableMetaData metaData = (ExtendableMetaData)this.delegate.create();
        this.processAttributes(metaData, reader);
        this.processElements(metaData, reader, propertyReplacer);
        return (MD)metaData;
    }

    protected void processAttributes(MD metaData, XMLStreamReader reader) throws XMLStreamException {
        AttributeProcessorHelper.processAttributes(metaData, reader, this);
    }

    @Override
    public void processAttribute(MD metaData, XMLStreamReader reader, int i) throws XMLStreamException {
        this.delegate.processAttribute(metaData, reader, i);
    }

    @Override
    protected void processElement(MD metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        switch (namespace) {
            case SPEC: 
            case SPEC_7_0: {
                this.delegate.processElement(metaData, reader, propertyReplacer);
                break;
            }
            case JBOSS: 
            case UNKNOWN: {
                AbstractMetaDataParser<?> parser = this.getParser(reader.getNamespaceURI());
                metaData.addAny(parser.parse(reader, propertyReplacer));
                break;
            }
            default: {
                throw new RuntimeException("Unable to process namespace " + (Object)((Object)namespace));
            }
        }
    }
}

