/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import rx.Subscription;
import rx.exceptions.Exceptions;

public final class SubscriptionList
implements Subscription {
    private LinkedList<Subscription> subscriptions;
    private volatile boolean unsubscribed;
    private final ReentrantLock lock = new ReentrantLock();

    public SubscriptionList() {
    }

    public SubscriptionList(Subscription ... subscriptions) {
        this.subscriptions = new LinkedList<Subscription>(Arrays.asList(subscriptions));
    }

    public SubscriptionList(Subscription s) {
        this.subscriptions = new LinkedList();
        this.subscriptions.add(s);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Subscription s) {
        if (s.isUnsubscribed()) {
            return;
        }
        if (!this.unsubscribed) {
            this.lock.lock();
            try {
                if (!this.unsubscribed) {
                    LinkedList<Subscription> subs = this.subscriptions;
                    if (subs == null) {
                        this.subscriptions = subs = new LinkedList();
                    }
                    subs.add(s);
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        s.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Subscription s) {
        if (!this.unsubscribed) {
            boolean unsubscribe = false;
            this.lock.lock();
            try {
                LinkedList<Subscription> subs = this.subscriptions;
                if (this.unsubscribed || subs == null) {
                    return;
                }
                unsubscribe = subs.remove(s);
            }
            finally {
                this.lock.unlock();
            }
            if (unsubscribe) {
                s.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        if (!this.unsubscribed) {
            LinkedList<Subscription> list;
            this.lock.lock();
            try {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                list = this.subscriptions;
                this.subscriptions = null;
            }
            finally {
                this.lock.unlock();
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        Exceptions.throwIfAny(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.unsubscribed) {
            LinkedList<Subscription> list;
            this.lock.lock();
            try {
                list = this.subscriptions;
                this.subscriptions = null;
            }
            finally {
                this.lock.unlock();
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriptions() {
        if (!this.unsubscribed) {
            this.lock.lock();
            try {
                boolean bl = !this.unsubscribed && this.subscriptions != null && !this.subscriptions.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }
}

