/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.jacorb.IORSettingsParser;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.SSLConfigValue;
import org.jboss.as.jacorb.SecurityAllowedValues;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JacORBSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final JacORBSubsystemParser INSTANCE = new JacORBSubsystemParser();

    private JacORBSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "jacorb");
        nodes.add(subsystem);
        Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
        switch (readerNS) {
            case JacORB_1_0: {
                this.readElement_1_0(readerNS, reader, subsystem);
                break;
            }
            case JacORB_1_1: 
            case JacORB_1_2: 
            case JacORB_1_3: {
                this.readElement_1_1(readerNS, reader, subsystem);
                break;
            }
            case JacORB_1_4: {
                this.readElement_1_4(readerNS, reader, nodes);
                break;
            }
            case JacORB_2_0: {
                this.readElement_2_0(readerNS, reader, nodes);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement_1_0(Namespace namespace, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            if (Namespace.JacORB_1_0 != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element) && element != Element.PROPERTY) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ORB: {
                    this.parseORBConfig_1_0(reader, node);
                    continue block8;
                }
                case POA: {
                    this.parsePOAConfig(namespace, reader, node);
                    continue block8;
                }
                case INTEROP: {
                    this.parseInteropConfig(reader, node);
                    continue block8;
                }
                case SECURITY: {
                    this.parseSecurityConfig_1_0(reader, node);
                    continue block8;
                }
                case PROPERTY: {
                    ModelNode propertiesNode = node.get("properties");
                    this.parseGenericProperty_1_0(reader, propertiesNode);
                    continue block8;
                }
                case ORB_INITIALIZERS: {
                    this.parseORBInitializersConfig_1_0(reader, node);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readElement_1_1(Namespace namespace, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            if (namespace != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ORB: {
                    this.parseORBConfig(namespace, reader, node);
                    continue block8;
                }
                case POA: {
                    this.parsePOAConfig(namespace, reader, node);
                    continue block8;
                }
                case NAMING: {
                    this.parseNamingConfig(reader, node);
                    continue block8;
                }
                case INTEROP: {
                    this.parseInteropConfig(reader, node);
                    continue block8;
                }
                case SECURITY: {
                    this.parseSecurityConfig(reader, node);
                    continue block8;
                }
                case PROPERTIES: {
                    this.parsePropertiesConfig(namespace, reader, node);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readElement_1_4(Namespace namespace, XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            if (namespace != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            ModelNode node = nodes.get(0);
            switch (element) {
                case ORB: {
                    this.parseORBConfig(namespace, reader, nodes.get(0));
                    continue block9;
                }
                case POA: {
                    this.parsePOAConfig(namespace, reader, node);
                    continue block9;
                }
                case NAMING: {
                    this.parseNamingConfig(reader, node);
                    continue block9;
                }
                case INTEROP: {
                    this.parseInteropConfig(reader, node);
                    continue block9;
                }
                case SECURITY: {
                    this.parseSecurityConfig(reader, node);
                    continue block9;
                }
                case IOR_SETTINGS: {
                    IORSettingsParser.INSTANCE.readElement(reader, nodes);
                    continue block9;
                }
                case PROPERTIES: {
                    this.parsePropertiesConfig(namespace, reader, node);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readElement_2_0(Namespace namespace, XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        this.readElement_1_4(namespace, reader, nodes);
    }

    private void parseORBConfig_1_0(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute[]> expectedAttributes = EnumSet.of(Attribute.NAME, new Attribute[]{Attribute.ORB_PRINT_VERSION, Attribute.ORB_GIOP_MINOR_VERSION, Attribute.ORB_USE_BOM, Attribute.ORB_USE_IMR, Attribute.ORB_CACHE_POA_NAMES, Attribute.ORB_CACHE_TYPECODES});
        this.parseAttributes(reader, node, expectedAttributes, null);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            if (Namespace.JacORB_1_0 != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ORB_CONNECTION: {
                    this.parseORBConnectionConfig(reader, node);
                    continue block4;
                }
                case NAMING: {
                    this.parseNamingConfig(reader, node);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseORBConfig(Namespace namespace, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute[]> expectedAttributes = EnumSet.of(Attribute.NAME, new Attribute[]{Attribute.ORB_PRINT_VERSION, Attribute.ORB_GIOP_MINOR_VERSION, Attribute.ORB_USE_BOM, Attribute.ORB_USE_IMR, Attribute.ORB_CACHE_POA_NAMES, Attribute.ORB_CACHE_TYPECODES});
        if (namespace.ordinal() >= Namespace.JacORB_1_2.ordinal()) {
            expectedAttributes.add((Attribute[])Attribute.ORB_SOCKET_BINDING);
            expectedAttributes.add((Attribute[])Attribute.ORB_SSL_SOCKET_BINDING);
        }
        if (namespace.ordinal() >= Namespace.JacORB_2_0.ordinal()) {
            expectedAttributes.add((Attribute[])Attribute.ORB_PERSISTENT_SERVER_ID);
        }
        this.parseAttributes(reader, node, expectedAttributes, null);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            if (namespace != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ORB_CONNECTION: {
                    this.parseORBConnectionConfig(reader, node);
                    continue block4;
                }
                case ORB_INITIALIZERS: {
                    this.parseORBInitializersConfig(reader, node);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseORBConnectionConfig(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute[]> attributes = EnumSet.of(Attribute.ORB_CONN_RETRIES, new Attribute[]{Attribute.ORB_CONN_RETRY_INTERVAL, Attribute.ORB_CONN_CLIENT_TIMEOUT, Attribute.ORB_CONN_SERVER_TIMEOUT, Attribute.ORB_CONN_MAX_SERVER_CONNECTIONS, Attribute.ORB_CONN_MAX_MANAGED_BUF_SIZE, Attribute.ORB_CONN_OUTBUF_SIZE, Attribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT});
        this.parseAttributes(reader, node, attributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseORBInitializersConfig_1_0(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String initializersList = reader.getElementText();
        if (initializersList != null) {
            String[] initializers;
            for (String initializer : initializers = initializersList.split(",")) {
                SimpleAttributeDefinition definition = (SimpleAttributeDefinition)JacORBSubsystemDefinitions.valueOf(initializer);
                if (definition == null || !JacORBSubsystemDefinitions.ORB_INIT_ATTRIBUTES.contains(definition)) {
                    throw JacORBLogger.ROOT_LOGGER.invalidInitializerConfig(initializer, reader.getLocation());
                }
                node.get(definition.getName()).set("on");
            }
        }
    }

    private void parseORBInitializersConfig(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute> attributes = EnumSet.of(Attribute.ORB_INIT_SECURITY, Attribute.ORB_INIT_TRANSACTIONS);
        this.parseAttributes(reader, node, attributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (node.has("security") && node.get("security").asString().equals("on")) {
            node.get("security").set(SecurityAllowedValues.IDENTITY.toString());
        }
    }

    private void parsePOAConfig(Namespace namespace, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute> expectedAttributes = EnumSet.of(Attribute.POA_MONITORING, Attribute.POA_QUEUE_WAIT, Attribute.POA_QUEUE_MIN, Attribute.POA_QUEUE_MAX);
        this.parseAttributes(reader, node, expectedAttributes, null);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            if (namespace != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case POA_REQUEST_PROC: {
                    EnumSet<Attribute> attributes = EnumSet.of(Attribute.POA_REQUEST_PROC_POOL_SIZE, Attribute.POA_REQUEST_PROC_MAX_THREADS);
                    this.parseAttributes(reader, node, attributes, null);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseNamingConfig(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute> expectedAttributes = EnumSet.of(Attribute.NAMING_ROOT_CONTEXT, Attribute.NAMING_EXPORT_CORBALOC);
        this.parseAttributes(reader, node, expectedAttributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseInteropConfig(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute[]> expectedAttributes = EnumSet.of(Attribute.INTEROP_SUN, new Attribute[]{Attribute.INTEROP_COMET, Attribute.INTEROP_IONA, Attribute.INTEROP_CHUNK_RMI_VALUETYPES, Attribute.INTEROP_LAX_BOOLEAN_ENCODING, Attribute.INTEROP_INDIRECTION_ENCODING_DISABLE, Attribute.INTEROP_STRICT_CHECK_ON_TC_CREATION});
        this.parseAttributes(reader, node, expectedAttributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSecurityConfig_1_0(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute[]> expectedAttributes = EnumSet.of(Attribute.SECURITY_SUPPORT_SSL, new Attribute[]{Attribute.SECURITY_ADD_COMPONENT_INTERCEPTOR, Attribute.SECURITY_CLIENT_SUPPORTS, Attribute.SECURITY_CLIENT_REQUIRES, Attribute.SECURITY_SERVER_SUPPORTS, Attribute.SECURITY_SERVER_REQUIRES, Attribute.SECURITY_USE_DOMAIN_SF, Attribute.SECURITY_USE_DOMAIN_SSF});
        EnumSet<Attribute> parsedAttributes = EnumSet.noneOf(Attribute.class);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (!expectedAttributes.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (!parsedAttributes.add(attribute)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
            }
            switch (attribute) {
                case SECURITY_CLIENT_SUPPORTS: 
                case SECURITY_CLIENT_REQUIRES: 
                case SECURITY_SERVER_SUPPORTS: 
                case SECURITY_SERVER_REQUIRES: {
                    SSLConfigValue value = SSLConfigValue.fromValue(attrValue);
                    if (value == null) {
                        throw JacORBLogger.ROOT_LOGGER.invalidSSLConfig(attrValue, reader.getLocation());
                    }
                    attrValue = value.toString();
                }
            }
            SimpleAttributeDefinition definition = (SimpleAttributeDefinition)JacORBSubsystemDefinitions.valueOf(attribute.getLocalName());
            if (definition == null) continue;
            definition.parseAndSetParameter(attrValue, node, (XMLStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSecurityConfig(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        EnumSet<Attribute[]> expectedAttributes = EnumSet.of(Attribute.SECURITY_SUPPORT_SSL, new Attribute[]{Attribute.SECURITY_SECURITY_DOMAIN, Attribute.SECURITY_ADD_COMPONENT_INTERCEPTOR, Attribute.SECURITY_CLIENT_SUPPORTS, Attribute.SECURITY_CLIENT_REQUIRES, Attribute.SECURITY_SERVER_SUPPORTS, Attribute.SECURITY_SERVER_REQUIRES});
        this.parseAttributes(reader, node, expectedAttributes, null);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePropertiesConfig(Namespace namespace, XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            if (namespace != Namespace.forUri(reader.getNamespaceURI())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseGenericProperty(reader, node.get("properties"));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseGenericProperty_1_0(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PROP_KEY, Attribute.PROP_VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PROP_KEY: {
                    name = value;
                    continue block4;
                }
                case PROP_VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        node.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseGenericProperty(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        String name = null;
        ModelNode val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PROP_VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case PROP_VALUE: {
                    val = JacORBSubsystemDefinitions.PROPERTIES.parse(value, reader.getLocation());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        node.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAttributes(XMLExtendedStreamReader reader, ModelNode node, EnumSet<Attribute> expectedAttributes, EnumSet<Attribute> requiredAttributes) throws XMLStreamException {
        EnumSet<Attribute> parsedAttributes = EnumSet.noneOf(Attribute.class);
        if (requiredAttributes == null) {
            requiredAttributes = EnumSet.noneOf(Attribute.class);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (!expectedAttributes.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (!parsedAttributes.add(attribute)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
            }
            requiredAttributes.remove((Object)attribute);
            ((SimpleAttributeDefinition)JacORBSubsystemDefinitions.valueOf(attribute.getLocalName())).parseAndSetParameter(attrValue, node, (XMLStreamReader)reader);
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        this.writeORBConfig(writer, node);
        this.writePOAConfig(writer, node);
        this.writeNamingConfig(writer, node);
        this.writeInteropConfig(writer, node);
        this.writeSecurityConfig(writer, node);
        String properties = "properties";
        if (node.hasDefined(properties)) {
            this.writeGenericProperties(writer, node.get(properties));
        }
        if (node.hasDefined("ior-settings")) {
            IORSettingsParser.INSTANCE.writeContent(writer, node.get(new String[]{"ior-settings", "default"}));
        }
        writer.writeEndElement();
    }

    private void writeORBConfig(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean writeORB = this.isWritable(node, JacORBSubsystemDefinitions.ORB_ATTRIBUTES);
        boolean writeORBConnection = this.isWritable(node, JacORBSubsystemDefinitions.ORB_CONN_ATTRIBUTES);
        boolean writeORBInitializer = this.isWritable(node, JacORBSubsystemDefinitions.ORB_INIT_ATTRIBUTES);
        if (!writeORBConnection && !writeORBInitializer) {
            if (writeORB) {
                writer.writeEmptyElement("orb");
                this.writeAttributes(writer, node, JacORBSubsystemDefinitions.ORB_ATTRIBUTES);
            }
        } else {
            writer.writeStartElement("orb");
            this.writeAttributes(writer, node, JacORBSubsystemDefinitions.ORB_ATTRIBUTES);
            if (writeORBConnection) {
                writer.writeEmptyElement("connection");
                this.writeAttributes(writer, node, JacORBSubsystemDefinitions.ORB_CONN_ATTRIBUTES);
            }
            if (writeORBInitializer) {
                writer.writeEmptyElement("initializers");
                this.writeAttributes(writer, node, JacORBSubsystemDefinitions.ORB_INIT_ATTRIBUTES);
            }
            writer.writeEndElement();
        }
    }

    private void writePOAConfig(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean writePOA = this.isWritable(node, JacORBSubsystemDefinitions.POA_ATTRIBUTES);
        boolean writePOARP = this.isWritable(node, JacORBSubsystemDefinitions.POA_RP_ATTRIBUTES);
        if (!writePOARP) {
            if (writePOA) {
                writer.writeEmptyElement("poa");
                this.writeAttributes(writer, node, JacORBSubsystemDefinitions.POA_ATTRIBUTES);
            }
        } else {
            writer.writeStartElement("poa");
            this.writeAttributes(writer, node, JacORBSubsystemDefinitions.POA_ATTRIBUTES);
            writer.writeEmptyElement("request-processors");
            this.writeAttributes(writer, node, JacORBSubsystemDefinitions.POA_RP_ATTRIBUTES);
            writer.writeEndElement();
        }
    }

    private void writeNamingConfig(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean writeNaming = this.isWritable(node, JacORBSubsystemDefinitions.NAMING_ATTRIBUTES);
        if (writeNaming) {
            writer.writeEmptyElement("naming");
            this.writeAttributes(writer, node, JacORBSubsystemDefinitions.NAMING_ATTRIBUTES);
        }
    }

    private void writeInteropConfig(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean writeInterop = this.isWritable(node, JacORBSubsystemDefinitions.INTEROP_ATTRIBUTES);
        if (writeInterop) {
            writer.writeEmptyElement("interop");
            this.writeAttributes(writer, node, JacORBSubsystemDefinitions.INTEROP_ATTRIBUTES);
        }
    }

    private void writeSecurityConfig(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean writeSecurity = this.isWritable(node, JacORBSubsystemDefinitions.SECURITY_ATTRIBUTES);
        if (writeSecurity) {
            writer.writeEmptyElement("security");
            this.writeAttributes(writer, node, JacORBSubsystemDefinitions.SECURITY_ATTRIBUTES);
        }
    }

    private void writeGenericProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement("properties");
        for (Property prop : node.asPropertyList()) {
            writer.writeEmptyElement("property");
            writer.writeAttribute("name", prop.getName());
            writer.writeAttribute("value", prop.getValue().asString());
        }
        writer.writeEndElement();
    }

    private void writeAttributes(XMLExtendedStreamWriter writer, ModelNode node, List<SimpleAttributeDefinition> attributes) throws XMLStreamException {
        for (SimpleAttributeDefinition definition : attributes) {
            definition.marshallAsAttribute(node, (XMLStreamWriter)writer);
        }
    }

    private boolean isWritable(ModelNode node, List<SimpleAttributeDefinition> attributeDefinitions) {
        boolean isWritable = false;
        for (SimpleAttributeDefinition attributeDefinition : attributeDefinitions) {
            if (!attributeDefinition.isMarshallable(node)) continue;
            isWritable = true;
            break;
        }
        return isWritable;
    }

    static enum Attribute {
        UNKNOWN(null),
        NAME("name"),
        ORB_PRINT_VERSION("print-version"),
        ORB_USE_IMR("use-imr"),
        ORB_USE_BOM("use-bom"),
        ORB_CACHE_TYPECODES("cache-typecodes"),
        ORB_CACHE_POA_NAMES("cache-poa-names"),
        ORB_GIOP_MINOR_VERSION("giop-minor-version"),
        ORB_SOCKET_BINDING("socket-binding"),
        ORB_SSL_SOCKET_BINDING("ssl-socket-binding"),
        ORB_PERSISTENT_SERVER_ID("persistent-server-id"),
        ORB_CONN_RETRIES("retries"),
        ORB_CONN_RETRY_INTERVAL("retry-interval"),
        ORB_CONN_CLIENT_TIMEOUT("client-timeout"),
        ORB_CONN_SERVER_TIMEOUT("server-timeout"),
        ORB_CONN_MAX_SERVER_CONNECTIONS("max-server-connections"),
        ORB_CONN_MAX_MANAGED_BUF_SIZE("max-managed-buf-size"),
        ORB_CONN_OUTBUF_SIZE("outbuf-size"),
        ORB_CONN_OUTBUF_CACHE_TIMEOUT("outbuf-cache-timeout"),
        ORB_INIT_SECURITY("security"),
        ORB_INIT_TRANSACTIONS("transactions"),
        POA_MONITORING("monitoring"),
        POA_QUEUE_WAIT("queue-wait"),
        POA_QUEUE_MIN("queue-min"),
        POA_QUEUE_MAX("queue-max"),
        POA_REQUEST_PROC_POOL_SIZE("pool-size"),
        POA_REQUEST_PROC_MAX_THREADS("max-threads"),
        NAMING_EXPORT_CORBALOC("export-corbaloc"),
        NAMING_ROOT_CONTEXT("root-context"),
        INTEROP_SUN("sun"),
        INTEROP_COMET("comet"),
        INTEROP_IONA("iona"),
        INTEROP_CHUNK_RMI_VALUETYPES("chunk-custom-rmi-valuetypes"),
        INTEROP_LAX_BOOLEAN_ENCODING("lax-boolean-encoding"),
        INTEROP_INDIRECTION_ENCODING_DISABLE("indirection-encoding-disable"),
        INTEROP_STRICT_CHECK_ON_TC_CREATION("strict-check-on-tc-creation"),
        SECURITY_SUPPORT_SSL("support-ssl"),
        SECURITY_SECURITY_DOMAIN("security-domain"),
        SECURITY_ADD_COMPONENT_INTERCEPTOR("add-component-via-interceptor"),
        SECURITY_CLIENT_SUPPORTS("client-supports"),
        SECURITY_CLIENT_REQUIRES("client-requires"),
        SECURITY_SERVER_SUPPORTS("server-supports"),
        SECURITY_SERVER_REQUIRES("server-requires"),
        SECURITY_USE_DOMAIN_SF("use-domain-socket-factory"),
        SECURITY_USE_DOMAIN_SSF("use-domain-server-socket-factory"),
        IOR_TRANSPORT_CONFIDENTIALITY("confidentiality"),
        IOR_TRANSPORT_DETECT_MISORDERING("detect-misordering"),
        IOR_TRANSPORT_DETECT_REPLAY("detect-replay"),
        IOR_TRANSPORT_INTEGRITY("integrity"),
        IOR_TRANSPORT_TRUST_IN_CLIENT("trust-in-client"),
        IOR_TRANSPORT_TRUST_IN_TARGET("trust-in-target"),
        IOR_AS_CONTEXT_AUTH_METHOD("auth-method"),
        IOR_AS_CONTEXT_REALM("realm"),
        IOR_AS_CONTEXT_REQUIRED("required"),
        IOR_SAS_CONTEXT_CALLER_PROPAGATION("caller-propagation"),
        PROP_KEY("key"),
        PROP_VALUE("value");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute attribute = MAP.get(localName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                String name = attribute.name;
                if (name == null) continue;
                map.put(name, attribute);
            }
            MAP = map;
        }
    }

    static enum Element {
        UNKNOWN(null),
        ORB("orb"),
        ORB_CONNECTION("connection"),
        ORB_INITIALIZERS("initializers"),
        POA("poa"),
        POA_REQUEST_PROC("request-processors"),
        NAMING("naming"),
        INTEROP("interop"),
        SECURITY("security"),
        PROPERTIES("properties"),
        PROPERTY("property"),
        IOR_SETTINGS("ior-settings"),
        IOR_TRANSPORT_CONFIG("transport-config"),
        IOR_AS_CONTEXT("as-context"),
        IOR_SAS_CONTEXT("sas-context");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    static enum Namespace {
        UNKNOWN(null),
        JacORB_1_0("urn:jboss:domain:jacorb:1.0"),
        JacORB_1_1("urn:jboss:domain:jacorb:1.1"),
        JacORB_1_2("urn:jboss:domain:jacorb:1.2"),
        JacORB_1_3("urn:jboss:domain:jacorb:1.3"),
        JacORB_1_4("urn:jboss:domain:jacorb:1.4"),
        JacORB_2_0("urn:jboss:domain:jacorb:2.0");

        static final Namespace CURRENT;
        private final String namespaceURI;
        private static final Map<String, Namespace> MAP;

        private Namespace(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        String getUriString() {
            return this.namespaceURI;
        }

        static Namespace forUri(String uri) {
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            CURRENT = JacORB_2_0;
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }
}

