/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.activation.NullActivator;
import org.jboss.aesh.cl.activation.OptionActivator;
import org.jboss.aesh.cl.completer.BooleanOptionCompleter;
import org.jboss.aesh.cl.completer.FileOptionCompleter;
import org.jboss.aesh.cl.completer.NullOptionCompleter;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.cl.converter.CLConverterManager;
import org.jboss.aesh.cl.converter.Converter;
import org.jboss.aesh.cl.converter.NullConverter;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.renderer.NullOptionRenderer;
import org.jboss.aesh.cl.renderer.OptionRenderer;
import org.jboss.aesh.cl.validator.NullValidator;
import org.jboss.aesh.cl.validator.OptionValidator;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.util.ReflectionUtil;

public class ProcessedOptionBuilder {
    private char shortName;
    private String name;
    private String description;
    private String argument;
    private Class<?> type;
    private boolean hasValue = true;
    private boolean required = false;
    private boolean isProperty = false;
    private boolean hasMultipleValues = false;
    private char valueSeparator = (char)44;
    private OptionType optionType;
    private Converter converter;
    private String fieldName;
    private OptionCompleter completer;
    private final List<String> defaultValues = new ArrayList<String>();
    private OptionValidator validator;
    private OptionActivator activator;
    private OptionRenderer renderer;
    private boolean overrideRequired;

    public ProcessedOptionBuilder shortName(char n) {
        this.shortName = n;
        return this;
    }

    public ProcessedOptionBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ProcessedOptionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ProcessedOptionBuilder argument(String argument) {
        this.argument = argument;
        return this;
    }

    public ProcessedOptionBuilder type(Class<?> type) {
        this.type = type;
        return this;
    }

    public ProcessedOptionBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public ProcessedOptionBuilder fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public ProcessedOptionBuilder hasValue(boolean hasValue) {
        this.hasValue = hasValue;
        return this;
    }

    public ProcessedOptionBuilder isProperty(boolean isProperty) {
        this.isProperty = isProperty;
        return this;
    }

    public ProcessedOptionBuilder hasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = hasMultipleValues;
        return this;
    }

    public ProcessedOptionBuilder addDefaultValue(String defaultValue) {
        this.defaultValues.add(defaultValue);
        return this;
    }

    public ProcessedOptionBuilder addAllDefaultValues(List<String> defaultValues) {
        this.defaultValues.addAll(defaultValues);
        return this;
    }

    public ProcessedOptionBuilder addAllDefaultValues(String[] defaultValues) {
        for (String s : defaultValues) {
            this.defaultValues.add(s);
        }
        return this;
    }

    public ProcessedOptionBuilder valueSeparator(char valueSeparator) {
        this.valueSeparator = valueSeparator;
        return this;
    }

    public ProcessedOptionBuilder optionType(OptionType optionType) {
        this.optionType = optionType;
        return this;
    }

    public ProcessedOptionBuilder converter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public ProcessedOptionBuilder converter(Class<? extends Converter> converter) {
        this.converter = this.initConverter(converter);
        return this;
    }

    private Converter initConverter(Class<? extends Converter> converterClass) {
        if (converterClass != null && !converterClass.equals(NullConverter.class)) {
            if (CLConverterManager.getInstance().hasConverter(converterClass)) {
                return CLConverterManager.getInstance().getConverter(converterClass);
            }
            return ReflectionUtil.newInstance(converterClass);
        }
        return CLConverterManager.getInstance().getConverter(this.type);
    }

    public ProcessedOptionBuilder completer(OptionCompleter completer) {
        this.completer = completer;
        return this;
    }

    public ProcessedOptionBuilder completer(Class<? extends OptionCompleter> completer) {
        this.completer = this.initCompleter(completer);
        return this;
    }

    private OptionCompleter initCompleter(Class<? extends OptionCompleter> completerClass) {
        if (completerClass != null && !completerClass.equals(NullOptionCompleter.class)) {
            return ReflectionUtil.newInstance(completerClass);
        }
        try {
            if (this.type == Boolean.class || this.type == Boolean.TYPE) {
                return (OptionCompleter)BooleanOptionCompleter.class.newInstance();
            }
            if (this.type == File.class || this.type == Resource.class) {
                return (OptionCompleter)FileOptionCompleter.class.newInstance();
            }
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProcessedOptionBuilder validator(OptionValidator validator) {
        this.validator = validator;
        return this;
    }

    public ProcessedOptionBuilder validator(Class<? extends OptionValidator> validator) {
        this.validator = this.initValidator(validator);
        return this;
    }

    private OptionValidator initValidator(Class<? extends OptionValidator> validator) {
        if (validator != null && validator != NullValidator.class) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullValidator();
    }

    public ProcessedOptionBuilder activator(OptionActivator activator) {
        this.activator = activator;
        return this;
    }

    public ProcessedOptionBuilder activator(Class<? extends OptionActivator> activator) {
        this.activator = this.initActivator(activator);
        return this;
    }

    private OptionActivator initActivator(Class<? extends OptionActivator> activator) {
        if (activator != null && activator != NullActivator.class) {
            return ReflectionUtil.newInstance(activator);
        }
        return new NullActivator();
    }

    public ProcessedOptionBuilder renderer(OptionRenderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public ProcessedOptionBuilder renderer(Class<? extends OptionRenderer> renderer) {
        this.renderer = this.initRenderer(renderer);
        return this;
    }

    private OptionRenderer initRenderer(Class<? extends OptionRenderer> renderer) {
        if (renderer != null && renderer != NullOptionRenderer.class) {
            return ReflectionUtil.newInstance(renderer);
        }
        return null;
    }

    public ProcessedOptionBuilder overrideRequired(boolean overrideRequired) {
        this.overrideRequired = overrideRequired;
        return this;
    }

    public ProcessedOption create() throws OptionParserException {
        if (this.optionType == null) {
            this.optionType = !this.hasValue ? OptionType.BOOLEAN : (this.isProperty ? OptionType.GROUP : (this.hasMultipleValues ? OptionType.LIST : OptionType.NORMAL));
        }
        if (this.name == null || this.name.length() < 1 && this.optionType != OptionType.ARGUMENT) {
            if (this.fieldName == null || this.fieldName.length() < 1) {
                throw new OptionParserException("Name must be defined to create an Option");
            }
            this.name = this.fieldName;
        }
        if (this.type == null) {
            throw new OptionParserException("Type must be defined to create an Option");
        }
        if (this.shortName == '\u0000' && this.name.equals("") && this.optionType != OptionType.ARGUMENT) {
            throw new OptionParserException("Either shortName or name must be set.");
        }
        if (this.validator == null) {
            this.validator = new NullValidator();
        }
        if (this.converter == null) {
            this.converter = CLConverterManager.getInstance().getConverter(this.type);
        }
        if (this.activator == null) {
            this.activator = new NullActivator();
        }
        if (this.renderer == null) {
            this.renderer = new NullOptionRenderer();
        }
        return new ProcessedOption(this.shortName, this.name, this.description, this.argument, this.required, this.valueSeparator, this.defaultValues, this.type, this.fieldName, this.optionType, this.converter, this.completer, this.validator, this.activator, this.renderer, this.overrideRequired);
    }
}

