/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Set;
import org.infinispan.Cache;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistry;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationFactoryAdapter;
import org.wildfly.clustering.server.provider.ServiceProviderRegistryServiceNameProvider;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;
import org.wildfly.clustering.spi.GroupServiceName;

public class CacheServiceProviderRegistryBuilder<T>
extends ServiceProviderRegistryServiceNameProvider
implements Builder<ServiceProviderRegistry<T>>,
Service<ServiceProviderRegistry<T>>,
CacheServiceProviderRegistryConfiguration<T> {
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();
    private volatile CacheServiceProviderRegistry<T> factory = null;

    public CacheServiceProviderRegistryBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
    }

    public ServiceBuilder<ServiceProviderRegistry<T>> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).addDependency(CacheServiceName.CACHE.getServiceName(this.containerName, this.cacheName), Cache.class, this.cache).addDependency(CacheGroupServiceName.GROUP.getServiceName(this.containerName, this.cacheName), Group.class, this.group).addDependency(GroupServiceName.COMMAND_DISPATCHER.getServiceName(this.containerName), CommandDispatcherFactory.class, this.dispatcherFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ServiceProviderRegistry<T> getValue() {
        return new ServiceProviderRegistrationFactoryAdapter<T>(this.factory);
    }

    public void start(StartContext context) {
        this.factory = new CacheServiceProviderRegistry(this);
    }

    public void stop(StopContext context) {
        this.factory.close();
        this.factory = null;
    }

    @Override
    public Object getId() {
        return this.getServiceName();
    }

    @Override
    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<T, Set<Node>> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }
}

