/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.nest.extension;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.hawkular.nest.extension.NestSubsystemDefinition;
import org.hawkular.nest.extension.log.MsgLogger;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class NestSubsystemExtension
implements Extension {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(NestSubsystemExtension.class);
    public static final String NAMESPACE = "urn:org.hawkular.nest:nest:1.0";
    public static final String SUBSYSTEM_NAME = "hawkular-nest";
    private final SubsystemParser parser = new SubsystemParser();
    private static final String RESOURCE_NAME = NestSubsystemExtension.class.getPackage().getName() + ".LocalDescriptions";
    protected static final String DEPLOYMENTS_DIR_NAME = "deployments";
    protected static final String NEST_ENABLED_ATTR = "enabled";
    protected static final boolean NEST_ENABLED_DEFAULT = false;
    protected static final String NEST_NAME_ELEMENT = "nest-name";
    protected static final String NEST_NAME_AUTOGENERATE = "autogenerate";
    protected static final String NEST_NAME_DEFAULT = "autogenerate";
    protected static final String CUSTOM_CONFIG_ELEMENT = "custom-configuration";
    protected static final String PROPERTY_ELEMENT = "property";
    protected static final String NEST_START_OP = "start";
    protected static final String NEST_STOP_OP = "stop";
    protected static final String NEST_STATUS_OP = "status";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"hawkular-nest");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, NestSubsystemExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        this.msglog.infoInitializingNestSubsystem();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)NestSubsystemDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)this.parser);
    }

    private static class SubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private SubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{NestSubsystemExtension.NEST_ENABLED_ATTR});
            ModelNode opAdd = new ModelNode();
            opAdd.get("operation").set("add");
            opAdd.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{SUBSYSTEM_PATH}).toModelNode());
            String brokerEnabledValue = reader.getAttributeValue(null, NestSubsystemExtension.NEST_ENABLED_ATTR);
            if (brokerEnabledValue != null) {
                opAdd.get(NestSubsystemExtension.NEST_ENABLED_ATTR).set(new ValueExpression(brokerEnabledValue));
            }
            while (reader.hasNext() && reader.nextTag() != 2) {
                String elementName = reader.getLocalName();
                if (elementName.equals(NestSubsystemExtension.CUSTOM_CONFIG_ELEMENT)) {
                    ModelNode configAttributeNode = opAdd.get(NestSubsystemExtension.CUSTOM_CONFIG_ELEMENT);
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        if (!reader.isStartElement()) continue;
                        this.readCustomConfigurationProperty(reader, configAttributeNode);
                    }
                    continue;
                }
                if (elementName.equals(NestSubsystemExtension.NEST_NAME_ELEMENT)) {
                    opAdd.get(NestSubsystemExtension.NEST_NAME_ELEMENT).set(new ValueExpression(reader.getElementText()));
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(opAdd);
        }

        private void readCustomConfigurationProperty(XMLExtendedStreamReader reader, ModelNode configAttributeNode) throws XMLStreamException {
            if (!reader.getLocalName().equals(NestSubsystemExtension.PROPERTY_ELEMENT)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
            String attr = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
            String val = reader.getAttributeValue(null, Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            configAttributeNode.add(attr, val);
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(NestSubsystemExtension.NAMESPACE, false);
            writer.writeAttribute(NestSubsystemExtension.NEST_ENABLED_ATTR, node.get(NestSubsystemExtension.NEST_ENABLED_ATTR).asString());
            this.writeElement(writer, node, NestSubsystemExtension.NEST_NAME_ELEMENT);
            writer.writeStartElement(NestSubsystemExtension.CUSTOM_CONFIG_ELEMENT);
            ModelNode configNode = node.get(NestSubsystemExtension.CUSTOM_CONFIG_ELEMENT);
            if (configNode != null && configNode.isDefined()) {
                for (Property property : configNode.asPropertyList()) {
                    writer.writeStartElement(NestSubsystemExtension.PROPERTY_ELEMENT);
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), property.getValue().asString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeElement(XMLExtendedStreamWriter writer, ModelNode node, String attribName) throws XMLStreamException {
            ModelNode attribNode = node.get(attribName);
            if (attribNode.isDefined()) {
                writer.writeStartElement(attribName);
                writer.writeCharacters(attribNode.asString());
                writer.writeEndElement();
            }
        }
    }
}

