/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.SecurityActions;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceLoaderAdapter
implements UnifiedVirtualFile {
    private static final long serialVersionUID = -8567810932195204615L;
    private final URL resourceURL;
    private final ClassLoader loader;
    private static final String jarFileSeparator = "/";

    public ResourceLoaderAdapter() {
        this(SecurityActions.getContextClassLoader());
    }

    public ResourceLoaderAdapter(ClassLoader loader) {
        this.resourceURL = null;
        this.loader = loader;
    }

    private ResourceLoaderAdapter(ClassLoader loader, URL resourceURL) {
        this.resourceURL = resourceURL;
        this.loader = loader;
    }

    private UnifiedVirtualFile findChild(String resourcePath, boolean throwExceptionIfNotFound) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null) {
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (resourceURL == null) {
                try {
                    File file = new File(resourcePath);
                    if (file.exists()) {
                        resourceURL = file.toURI().toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (resourceURL == null) {
                try {
                    resourceURL = this.loader.getResource(resourcePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (resourceURL == null) {
            if (throwExceptionIfNotFound) {
                throw Messages.MESSAGES.cannotGetURLFor(resourcePath);
            }
            if (Loggers.ROOT_LOGGER.isTraceEnabled()) {
                Loggers.ROOT_LOGGER.cannotGetURLFor(resourcePath);
            }
            return null;
        }
        return new ResourceLoaderAdapter(this.loader, resourceURL);
    }

    public UnifiedVirtualFile findChild(String child) throws IOException {
        return this.findChild(child, true);
    }

    public UnifiedVirtualFile findChildFailSafe(String child) {
        try {
            return this.findChild(child, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL toURL() {
        if (null == this.resourceURL) {
            throw Messages.MESSAGES.unifiedVirtualFileNotInitialized(this.loader);
        }
        return this.resourceURL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<UnifiedVirtualFile> getChildren() throws IOException {
        if (null == this.resourceURL) {
            throw Messages.MESSAGES.unifiedVirtualFileNotInitialized(this.loader);
        }
        LinkedList<UnifiedVirtualFile> list = new LinkedList<UnifiedVirtualFile>();
        if (this.resourceURL.getProtocol().equals("jar")) {
            String path;
            String urlString = this.resourceURL.toExternalForm();
            String jarRoot = urlString.substring(4, urlString.indexOf("ar!") + 2);
            String string = path = urlString.contains("!") ? urlString.substring(urlString.lastIndexOf("!") + 2) : "";
            if (path.endsWith(jarFileSeparator)) {
                path = path.substring(0, path.lastIndexOf(jarFileSeparator));
            }
            try {
                String folder = jarRoot.substring(5, jarRoot.lastIndexOf(jarFileSeparator));
                String filename = jarRoot.substring(jarRoot.lastIndexOf(jarFileSeparator) + 1);
                final File jar = new File(folder, filename);
                PrivilegedAction<JarFile> action = new PrivilegedAction<JarFile>(){

                    @Override
                    public JarFile run() {
                        try {
                            return new JarFile(jar);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                JarFile jarFile = AccessController.doPrivileged(action);
                if (!jar.canRead()) return list;
                Enumeration<JarEntry> entries = jarFile.entries();
                LinkedList<String> pathMatch = new LinkedList<String>();
                LinkedList<String> finalMatch = new LinkedList<String>();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(path + jarFileSeparator) || name.length() <= path.length() + 1 || name.contains("$")) continue;
                    pathMatch.add(name.substring(path.length() + 1));
                }
                for (String s : pathMatch) {
                    if (s.contains(jarFileSeparator) && s.indexOf(jarFileSeparator) != s.length() - 1) continue;
                    finalMatch.add(s);
                }
                for (String s : finalMatch) {
                    URL sUrl = new URL(urlString + jarFileSeparator + s);
                    list.add(new ResourceLoaderAdapter(this.loader, sUrl));
                }
                return list;
            }
            catch (Exception e) {
                Loggers.ROOT_LOGGER.cannotGetChildrenForResource(e, this.resourceURL);
                return list;
            }
        }
        try {
            File[] files;
            File file = new File(this.resourceURL.toURI());
            if (!file.exists() || !file.isDirectory() || (files = file.listFiles()) == null) return list;
            for (File f : files) {
                list.add(new ResourceLoaderAdapter(this.loader, f.toURI().toURL()));
            }
            return list;
        }
        catch (Exception e) {
            Loggers.ROOT_LOGGER.cannotGetChildrenForResource(e, this.resourceURL);
        }
        return list;
    }

    public String getName() {
        if (null == this.resourceURL) {
            throw Messages.MESSAGES.unifiedVirtualFileNotInitialized(this.loader);
        }
        String name = null;
        try {
            String filename = this.resourceURL.getFile();
            File f = new File(filename);
            name = f.getName();
            if (f.isDirectory() || this.resourceURL.getProtocol().equals("jar") && filename.endsWith(jarFileSeparator)) {
                name = name + jarFileSeparator;
            }
        }
        catch (Exception e) {
            Loggers.ROOT_LOGGER.cannotGetNameForResource(e, this.resourceURL);
        }
        return name;
    }
}

