/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hawkular.inventory.api.model.AbstractHashTree;
import org.hawkular.inventory.api.model.ComputeHash;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;

public final class Hashes
implements Serializable {
    private final String identityHash;
    private final String contentHash;
    private final String syncHash;

    public static Hashes of(InventoryStructure<?> root, CanonicalPath rootPath) {
        return ComputeHash.of(root, rootPath, true, true, true);
    }

    public static Tree treeOf(InventoryStructure<?> root, CanonicalPath rootPath, Function<RelativePath, Hashes> hashLoader) {
        Tree.AbstractBuilder[] tbld = new Tree.AbstractBuilder[1];
        Consumer<ComputeHash.IntermediateHashContext> startChild = context -> {
            tbld[0] = tbld[0] == null ? Tree.builder() : (Tree.AbstractBuilder)tbld[0].startChild();
        };
        BiConsumer<ComputeHash.IntermediateHashContext, ComputeHash.IntermediateHashResult> endChild = (ctx, result) -> {
            if (tbld[0] instanceof Tree.ChildBuilder) {
                tbld[0].withHash(new Hashes((ComputeHash.IntermediateHashResult)result)).withPath(result.path);
                Tree.AbstractBuilder parent = (Tree.AbstractBuilder)((Tree.ChildBuilder)tbld[0]).getParent();
                parent.addChild(((Tree.ChildBuilder)tbld[0]).build());
                tbld[0] = parent;
            }
        };
        ComputeHash.IntermediateHashResult res = ComputeHash.treeOf(root, rootPath, true, true, true, startChild, endChild, hashLoader);
        tbld[0].withPath(res.path).withHash((Hashes)new Hashes(res));
        return ((Tree.Builder)tbld[0]).build();
    }

    public static Tree treeOf(InventoryStructure<?> root, CanonicalPath rootPath) {
        return Hashes.treeOf(root, rootPath, rp -> null);
    }

    public Hashes(String identityHash, String contentHash, String syncHash) {
        this.identityHash = identityHash;
        this.contentHash = contentHash;
        this.syncHash = syncHash;
    }

    Hashes(ComputeHash.IntermediateHashResult res) {
        this(res.identityHash, res.contentHash, res.syncHash);
    }

    public String getIdentityHash() {
        return this.identityHash;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public String getSyncHash() {
        return this.syncHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hashes hashes = (Hashes)o;
        if (this.identityHash != null ? !this.identityHash.equals(hashes.identityHash) : hashes.identityHash != null) {
            return false;
        }
        if (this.contentHash != null ? !this.contentHash.equals(hashes.contentHash) : hashes.contentHash != null) {
            return false;
        }
        return this.syncHash != null ? this.syncHash.equals(hashes.syncHash) : hashes.syncHash == null;
    }

    public int hashCode() {
        int result = this.identityHash != null ? this.identityHash.hashCode() : 0;
        result = 31 * result + (this.contentHash != null ? this.contentHash.hashCode() : 0);
        result = 31 * result + (this.syncHash != null ? this.syncHash.hashCode() : 0);
        return result;
    }

    public static final class Tree
    extends AbstractHashTree<Tree, Hashes> {
        private Tree() {
            this(null, null, null);
        }

        private Tree(RelativePath path, Hashes hash, Map<Path.Segment, Tree> children) {
            super(path, hash == null ? new Hashes(null, null, null) : hash, children);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class ChildBuilder<Parent extends AbstractHashTree.Builder<Parent, ChildBuilder<Parent>, Tree, Hashes> & AbstractBuilder<Parent>>
        extends AbstractHashTree.AbstractChildBuilder<ChildBuilder<Parent>, Parent, ChildBuilder<ChildBuilder<Parent>>, Tree, Hashes>
        implements AbstractBuilder<ChildBuilder<Parent>>,
        AbstractHashTree.ChildBuilder<ChildBuilder<Parent>, Parent, ChildBuilder<ChildBuilder<Parent>>, Tree, Hashes> {
            ChildBuilder(AbstractHashTree.TreeConstructor<Tree, Hashes> tctor, Parent p) {
                super(tctor, p, ChildBuilder::new);
            }
        }

        public static final class Builder
        extends AbstractHashTree.AbstractBuilder<Builder, ChildBuilder<Builder>, Tree, Hashes>
        implements AbstractBuilder<Builder>,
        AbstractHashTree.TopBuilder<Builder, ChildBuilder<Builder>, Tree, Hashes> {
            private Builder() {
                super((x$0, x$1, x$2) -> new Tree(x$0, (Hashes)x$1, x$2), ChildBuilder::new);
            }

            @Override
            public Tree build() {
                return (Tree)super.build();
            }
        }

        public static interface AbstractBuilder<This extends AbstractHashTree.Builder<This, ChildBuilder<This>, Tree, Hashes> & AbstractBuilder<This>>
        extends AbstractHashTree.Builder<This, ChildBuilder<This>, Tree, Hashes> {
        }
    }
}

